/*
 * Decompiled with CFR 0.152.
 */
package me.bunnykick.bunnyapi.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.bunnykick.bunnyapi.commands.SubCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicCommand<T extends JavaPlugin>
implements TabExecutor {
    protected final T plugin;
    protected final Map<String, SubCommand> subCommands;

    public BasicCommand(T plugin, String commandName) {
        this.plugin = plugin;
        this.subCommands = new HashMap<String, SubCommand>();
        Objects.requireNonNull(this.plugin.getCommand(commandName)).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.plugin.getCommand(commandName)).setTabCompleter((TabCompleter)this);
        this.loadSubCommands();
    }

    protected abstract void loadSubCommands();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.executePlayer(player, args);
        } else {
            this.executeServer(sender, args);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return this.tabCompletePlayer(player, args);
        }
        return this.tabCompleteServer(sender, args);
    }

    protected void registerSubCommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getName().toLowerCase(), subCommand);
    }

    protected abstract void executePlayer(Player var1, String[] var2);

    protected abstract void executeServer(CommandSender var1, String[] var2);

    protected abstract List<String> tabCompletePlayer(Player var1, String[] var2);

    protected abstract List<String> tabCompleteServer(CommandSender var1, String[] var2);
}

