/*
 * Decompiled with CFR 0.152.
 */
package me.bunnykick.bunnyapi.configs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import me.bunnykick.bunnyapi.configs.ConfigPathFile;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BasicFileManager<T extends JavaPlugin>
extends ConfigPathFile<T> {
    private final String configName;

    public BasicFileManager(T plugin, String configName) throws IOException, InvalidConfigurationException {
        this.configName = configName + ".yml";
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), this.configName);
        this.load();
    }

    @Override
    protected void load() throws IOException, InvalidConfigurationException {
        block16: {
            try (InputStream classStream = this.plugin.getClass().getResourceAsStream("/" + this.configName);){
                if (classStream == null) {
                    this.config = YamlConfiguration.loadConfiguration((File)this.file);
                    if (!this.file.exists()) {
                        this.config.options().copyDefaults(true);
                        this.setDefaults();
                        this.save();
                    } else {
                        this.config.load(this.file);
                    }
                    break block16;
                }
                try (InputStreamReader streamReader = new InputStreamReader(classStream);){
                    this.config = YamlConfiguration.loadConfiguration((Reader)streamReader);
                    if (!this.file.exists()) {
                        this.config.options().copyDefaults(true);
                        this.save();
                    } else {
                        this.config.load(this.file);
                    }
                }
            }
        }
    }

    @Override
    protected void save() throws IOException {
        this.config.save(this.file);
    }

    protected abstract void setDefaults();
}

