/*
 * Decompiled with CFR 0.152.
 */
package me.bunnykick.bunnyapi.gui;

import java.util.Objects;
import me.bunnykick.bunnyapi.utils.ItemStackBuilder;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class GUI<T extends JavaPlugin>
implements Listener {
    protected final Inventory inv;
    protected final T plugin;
    protected final int size;
    protected final String name;
    private final boolean cancel;

    public GUI(T plugin, int size, String name, boolean cancel) {
        this.plugin = plugin;
        this.cancel = cancel;
        this.size = size;
        this.name = name;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        this.inv = this.getInventory();
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
    }

    @EventHandler
    public void onPlayerClick(InventoryClickEvent event) {
        if (!Objects.equals(event.getClickedInventory(), this.inv)) {
            return;
        }
        if (this.cancel) {
            event.setCancelled(true);
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        this.doClick(player, event.getSlot(), event);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!Objects.equals(event.getInventory(), this.inv)) {
            return;
        }
        this.onClose((Player)event.getPlayer());
    }

    protected void fill() {
        this.fill(Material.BLACK_STAINED_GLASS_PANE);
    }

    protected void fill(Material material) {
        ItemStack fillItem = new ItemStackBuilder(material).setName("").hideAttributes().getItem();
        for (int i = 0; i < this.inv.getSize(); ++i) {
            if (this.inv.getItem(i) != null) continue;
            this.inv.setItem(i, fillItem);
        }
    }

    protected abstract Inventory getInventory();

    protected abstract void initializeItems();

    protected abstract void doClick(Player var1, int var2, InventoryClickEvent var3);

    protected abstract void onClose(Player var1);
}

