/*
 * Decompiled with CFR 0.152.
 */
package me.bunnykick.bunnyapi.utils;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.bunnykick.bunnyapi.BunnyAPI;
import me.bunnykick.bunnyapi.own.configs.ConfigManager;
import me.bunnykick.bunnyapi.own.configs.ConfigPaths;
import me.bunnykick.bunnyapi.utils.exception.PlayerNotFoundException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class Utils {
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("<gradient:(#[a-fA-F0-9]{6}):(#[a-fA-F0-9]{6})>(.*?)</gradient>");
    private static final DecimalFormat df = new DecimalFormat("0.00");

    public static String parseGradient(String input) {
        if (input == null) {
            throw new NullPointerException("input should not be null");
        }
        Matcher matcher = GRADIENT_PATTERN.matcher(input);
        StringBuilder builder = new StringBuilder();
        boolean found = false;
        while (matcher.find()) {
            found = true;
            String startColor = matcher.group(1);
            String endColor = matcher.group(2);
            String text = matcher.group(3);
            String result = Utils.applyGradient(text, Color.decode(startColor), Color.decode(endColor));
            matcher.appendReplacement(builder, Matcher.quoteReplacement(result));
        }
        matcher.appendTail(builder);
        return found ? builder.toString() : input;
    }

    public static String applyGradient(String text, Color startColor, Color endColor) {
        StringBuilder gradientText = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            float ratio = (float)i / (float)(length - 1);
            int r = (int)((float)startColor.getRed() * (1.0f - ratio) + (float)endColor.getRed() * ratio);
            int g = (int)((float)startColor.getGreen() * (1.0f - ratio) + (float)endColor.getGreen() * ratio);
            int b = (int)((float)startColor.getBlue() * (1.0f - ratio) + (float)endColor.getBlue() * ratio);
            String colorCode = Utils.toLegacyColorCode(new Color(r, g, b));
            gradientText.append(colorCode).append(text.charAt(i));
        }
        return gradientText.toString();
    }

    public static Component applyComponentGradient(String text, Color startColor, Color endColor) {
        TextComponent result = Component.empty();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            float ratio = (float)i / (float)(length - 1);
            int r = (int)((float)startColor.getRed() * (1.0f - ratio) + (float)endColor.getRed() * ratio);
            int g = (int)((float)startColor.getGreen() * (1.0f - ratio) + (float)endColor.getGreen() * ratio);
            int b = (int)((float)startColor.getBlue() * (1.0f - ratio) + (float)endColor.getBlue() * ratio);
            TextColor color = TextColor.color((int)r, (int)g, (int)b);
            result = result.append((Component)Component.text((char)text.charAt(i), (TextColor)color));
        }
        return result;
    }

    public static String applyColor(String text, Color color) {
        return Utils.toLegacyColorCode(color) + text;
    }

    public static Component applyComponentColor(String text, Color color) {
        return Component.text((String)text, (TextColor)TextColor.color((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
    }

    private static String toLegacyColorCode(Color color) {
        return String.format("\u00a7x\u00a7%x\u00a7%x\u00a7%x\u00a7%x\u00a7%x\u00a7%x", color.getRed() >> 4 & 0xF, color.getRed() & 0xF, color.getGreen() >> 4 & 0xF, color.getGreen() & 0xF, color.getBlue() >> 4 & 0xF, color.getBlue() & 0xF);
    }

    public static String round(double d) {
        return df.format(d);
    }

    public static int firstEmpty(Inventory inv) {
        for (int i = 0; i < inv.getSize(); ++i) {
            if (inv.getItem(i) != null && inv.getItem(i).getType() != Material.AIR) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasPermission(Player player, String permission) {
        ConfigManager config = BunnyAPI.getInstance().getConfigManager();
        return Utils.hasPermission(player, permission, Utils.replaceColorCodes(config.getString(ConfigPaths.MESSAGES_ERROR_PERMISSION)));
    }

    public static boolean hasPermission(Player player, String permission, String errorMessage) {
        if (!player.hasPermission(permission)) {
            player.sendMessage(errorMessage);
            return false;
        }
        return true;
    }

    public static Player getPlayer(String playerName) throws PlayerNotFoundException {
        try {
            return BunnyAPI.getInstance().getServer().getPlayer(playerName);
        }
        catch (NullPointerException exception) {
            throw new PlayerNotFoundException("Spieler " + playerName + " nicht gefunden");
        }
    }

    public static OfflinePlayer getOfflinePlayer(String playerName) throws PlayerNotFoundException {
        try {
            return BunnyAPI.getInstance().getServer().getOfflinePlayer(playerName);
        }
        catch (NullPointerException exception) {
            throw new PlayerNotFoundException("Spieler " + playerName + " nicht gefunden");
        }
    }

    public static String replaceColorCodes(String msg) {
        return msg.replace("&", "\u00a7");
    }

    public static Location getTargetBlockLocation(Player player) {
        Block block = player.getTargetBlockExact(10);
        return block == null ? null : block.getLocation();
    }

    public static String toSmallCaps(String input) {
        String upper = input.toUpperCase();
        StringBuilder result = new StringBuilder();
        Map map = Map.ofEntries(Map.entry(Character.valueOf('A'), "\u1d00"), Map.entry(Character.valueOf('B'), "\u0299"), Map.entry(Character.valueOf('C'), "\u1d04"), Map.entry(Character.valueOf('D'), "\u1d05"), Map.entry(Character.valueOf('E'), "\u1d07"), Map.entry(Character.valueOf('F'), "\ua730"), Map.entry(Character.valueOf('G'), "\u0262"), Map.entry(Character.valueOf('H'), "\u029c"), Map.entry(Character.valueOf('I'), "\u026a"), Map.entry(Character.valueOf('J'), "\u1d0a"), Map.entry(Character.valueOf('K'), "\u1d0b"), Map.entry(Character.valueOf('L'), "\u029f"), Map.entry(Character.valueOf('M'), "\u1d0d"), Map.entry(Character.valueOf('N'), "\u0274"), Map.entry(Character.valueOf('O'), "\u1d0f"), Map.entry(Character.valueOf('P'), "\u1d18"), Map.entry(Character.valueOf('Q'), "\ua7af"), Map.entry(Character.valueOf('R'), "\u0280"), Map.entry(Character.valueOf('S'), "\ua731"), Map.entry(Character.valueOf('T'), "\u1d1b"), Map.entry(Character.valueOf('U'), "\u1d1c"), Map.entry(Character.valueOf('V'), "\u1d20"), Map.entry(Character.valueOf('W'), "\u1d21"), Map.entry(Character.valueOf('X'), "x"), Map.entry(Character.valueOf('Y'), "\u028f"), Map.entry(Character.valueOf('Z'), "\u1d22"), Map.entry(Character.valueOf('\u00c4'), "\u00e4"), Map.entry(Character.valueOf('\u00d6'), "\u00f6"), Map.entry(Character.valueOf('\u00dc'), "\u00fc"));
        for (int i = 0; i < upper.length(); ++i) {
            char previous;
            char current = upper.charAt(i);
            char c = previous = i > 0 ? upper.charAt(i - 1) : (char)'\u0000';
            if (previous == '\u00a7') {
                result.append(current);
                continue;
            }
            result.append(map.getOrDefault(Character.valueOf(current), String.valueOf(current)));
        }
        return result.toString();
    }
}

