/*
 * Decompiled with CFR 0.152.
 */
package me.bunnykick.bunnyapi.configs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.bunnykick.bunnyapi.configs.ConfigPath;
import me.bunnykick.bunnyapi.utils.Utils;
import me.bunnykick.bunnyapi.utils.exception.PathNotExistsException;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class ConfigPathFile<T extends JavaPlugin> {
    private File file;
    private FileConfiguration config;
    private T plugin;

    public void setPath(ConfigPath path, Object value) {
        this.config.set(path.getPath(), value);
        try {
            this.save();
        }
        catch (IOException e) {
            throw new PathNotExistsException(this.file.getName() + " does not contain path: " + path.getPath());
        }
    }

    public String getString(ConfigPath path) {
        if (!this.config.contains(path.getPath())) {
            throw new PathNotExistsException(this.file.getName() + " does not contain path: " + path.getPath());
        }
        return this.config.getString(path.getPath());
    }

    public int getInt(ConfigPath path) {
        if (!this.config.contains(path.getPath())) {
            throw new PathNotExistsException(this.file.getName() + " does not contain path: " + path.getPath());
        }
        return this.config.getInt(path.getPath());
    }

    public boolean getBoolean(ConfigPath path) {
        if (!this.config.contains(path.getPath())) {
            throw new PathNotExistsException(this.file.getName() + " does not contain path: " + path.getPath());
        }
        return this.config.getBoolean(path.getPath());
    }

    public Location getLocation(ConfigPath path) {
        if (!this.config.contains(path.getPath())) {
            throw new PathNotExistsException(this.file.getName() + " does not contain path: " + path.getPath());
        }
        return this.config.getLocation(path.getPath());
    }

    public ItemStack getItemStack(ConfigPath path) {
        if (!this.config.contains(path.getPath())) {
            throw new PathNotExistsException(this.file.getName() + " does not contain path: " + path.getPath());
        }
        return this.config.getItemStack(path.getPath());
    }

    public List<String> getStringList(ConfigPath path) {
        if (!this.config.contains(path.getPath())) {
            throw new PathNotExistsException(this.file.getName() + " does not contain path: " + path.getPath());
        }
        return this.config.getStringList(path.getPath());
    }

    public Map<String, String> getStringMapFromStringList(ConfigPath path, String delimiter) {
        return this.getStringList(path).stream().map(Utils::replaceColorCodes).map(value -> value.split(delimiter)).collect(Collectors.toMap(pair -> pair[0], pair -> pair[1]));
    }

    public ConfigurationSection getConfigSection(String path) {
        return this.config.getConfigurationSection(path);
    }

    public boolean isSet(String path) {
        return this.config.contains(path);
    }

    protected File getFile() {
        return this.file;
    }

    protected void setFile(File configFile) {
        this.file = configFile;
    }

    protected FileConfiguration getConfig() {
        return this.config;
    }

    protected void setConfig(FileConfiguration configuration) {
        this.config = configuration;
    }

    protected T getPlugin() {
        return this.plugin;
    }

    protected void setPlugin(T pPlugin) {
        this.plugin = pPlugin;
    }

    protected abstract void save() throws IOException;

    protected abstract void load() throws IOException, InvalidConfigurationException;
}

