/*
 * Decompiled with CFR 0.152.
 */
package me.bunnykick.bunnyapi.gui;

import java.util.Objects;
import me.bunnykick.bunnyapi.utils.ItemStackBuilder;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class GUI<T extends JavaPlugin>
implements Listener {
    private final Inventory inv;
    private final T plugin;
    private final int size;
    private final String name;
    private final boolean cancel;

    public GUI(T pPlugin, int pSize, String pName, boolean pCancel) {
        this.plugin = pPlugin;
        this.cancel = pCancel;
        this.size = pSize;
        this.name = pName;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.inv = this.createInventory();
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
    }

    @EventHandler
    public void onPlayerClick(InventoryClickEvent event) {
        if (!Objects.equals(event.getClickedInventory(), this.inv)) {
            return;
        }
        if (this.cancel) {
            event.setCancelled(true);
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        this.doClick(player, event.getSlot(), event);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!Objects.equals(event.getInventory(), this.inv)) {
            return;
        }
        this.onClose((Player)event.getPlayer());
    }

    protected void fill() {
        this.fill(Material.BLACK_STAINED_GLASS_PANE);
    }

    protected void fill(Material material) {
        ItemStack fillItem = new ItemStackBuilder(material).setName("").hideAttributes().getItemStack();
        for (int i = 0; i < this.inv.getSize(); ++i) {
            if (this.inv.getItem(i) != null) continue;
            this.inv.setItem(i, fillItem);
        }
    }

    protected Inventory getInv() {
        return this.inv;
    }

    protected T getPlugin() {
        return this.plugin;
    }

    protected int getSize() {
        return this.size;
    }

    protected String getName() {
        return this.name;
    }

    protected abstract Inventory createInventory();

    protected abstract void initializeItems();

    protected abstract void doClick(Player var1, int var2, InventoryClickEvent var3);

    protected abstract void onClose(Player var1);
}

