/*
 * Decompiled with CFR 0.152.
 */
package me.bunnykick.bunnyapi.configs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import me.bunnykick.bunnyapi.configs.ConfigPathFile;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BasicFileManager<T extends JavaPlugin>
extends ConfigPathFile<T> {
    private final String configName;

    public BasicFileManager(T plugin, String pConfigName) throws IOException, InvalidConfigurationException {
        this.configName = pConfigName + ".yml";
        this.setPlugin(plugin);
        this.setFile(new File(plugin.getDataFolder(), this.configName));
        this.load();
    }

    @Override
    protected void load() throws IOException, InvalidConfigurationException {
        block16: {
            try (InputStream classStream = this.getPlugin().getClass().getResourceAsStream("/" + this.configName);){
                if (classStream == null) {
                    this.setConfig((FileConfiguration)YamlConfiguration.loadConfiguration((File)this.getFile()));
                    if (!this.getFile().exists()) {
                        this.getConfig().options().copyDefaults(true);
                        this.setDefaults();
                        this.save();
                    } else {
                        this.getConfig().load(this.getFile());
                    }
                    break block16;
                }
                try (InputStreamReader streamReader = new InputStreamReader(classStream);){
                    this.setConfig((FileConfiguration)YamlConfiguration.loadConfiguration((Reader)streamReader));
                    if (!this.getFile().exists()) {
                        this.getConfig().options().copyDefaults(true);
                        this.save();
                    } else {
                        this.getConfig().load(this.getFile());
                    }
                }
            }
        }
    }

    @Override
    protected void save() throws IOException {
        this.getConfig().save(this.getFile());
    }

    protected abstract void setDefaults();
}

