/*
 * Decompiled with CFR 0.152.
 */
package me.bunnykick.bunnyapi.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemStackBuilder {
    private final ItemStack itemStack;
    private final ItemMeta itemMeta;

    public ItemStackBuilder(Material material) {
        this.itemStack = new ItemStack(material);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemStackBuilder setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    public ItemStackBuilder addEnchantment(Enchantment enchantment, int level) {
        this.itemMeta.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemStackBuilder addLore(String ... strings) {
        ArrayList<String> lore = this.itemMeta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.addAll(Arrays.asList(strings));
        this.itemMeta.setLore(lore);
        return this;
    }

    public ItemStackBuilder setLore(List<String> lore) {
        this.itemMeta.setLore(lore);
        return this;
    }

    public ItemStackBuilder setName(String name) {
        this.itemMeta.setDisplayName(name);
        return this;
    }

    public ItemStackBuilder hideAttributes() {
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_DYE, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_ARMOR_TRIM, ItemFlag.HIDE_UNBREAKABLE});
        return this;
    }

    public ItemStack getItemStack() {
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }

    protected ItemMeta getItemMeta() {
        return this.itemMeta;
    }
}

