/*
 * Decompiled with CFR 0.152.
 */
package de.bunnykick.bunnyhomes.gui;

import de.bunnykick.bunnyhomes.BunnyHomes;
import de.bunnykick.bunnyhomes.Home;
import de.bunnykick.bunnyhomes.files.ConfigManager;
import de.bunnykick.bunnyhomes.files.ConfigPaths;
import de.bunnykick.bunnyhomes.gui.ConfirmInventory;
import java.io.IOException;
import java.util.List;
import me.bunnykick.bunnyapi.gui.GUI;
import me.bunnykick.bunnyapi.utils.ItemStackBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class HomeInventory
extends GUI<BunnyHomes> {
    private final Player owner;
    private final int row = 9;
    private final int rowBed = 1;
    private final int rowGreen = 2;
    private final int rowRed = 3;

    public HomeInventory(BunnyHomes pPlugin, Player pPlayer) {
        super((JavaPlugin)pPlugin, 45, "\u00a72Homes - " + pPlayer.getName(), true);
        this.owner = pPlayer;
        this.initializeItems();
    }

    protected Inventory createInventory() {
        return Bukkit.createInventory(null, (int)this.getSize(), (String)this.getName());
    }

    protected void initializeItems() {
        ItemStack pane = new ItemStackBuilder(Material.BLACK_STAINED_GLASS_PANE).setName(" ").setAmount(1).hideAttributes().getItemStack();
        ItemStack green = new ItemStackBuilder(Material.LIME_DYE).setName("\u00a72SetHome").setAmount(1).hideAttributes().getItemStack();
        ItemStack red = new ItemStackBuilder(Material.RED_DYE).setName("\u00a7cDelHome").setAmount(1).hideAttributes().getItemStack();
        for (int i = 0; i < this.getSize(); ++i) {
            if (i < 9 || i >= this.getSize() - 9 || i % 9 == 0 || i % 9 == 8) {
                this.getInv().setItem(i, pane);
            }
            if (9 < i && i < 17) {
                int cur = i % 9;
                this.getInv().setItem(i, this.getBed(cur));
            }
            if (18 < i && i < 26) {
                this.getInv().setItem(i, green);
            }
            if (27 >= i || i >= 35) continue;
            this.getInv().setItem(i, red);
        }
    }

    private ItemStack getBed(int slot) {
        ConfigPaths lorePath;
        ConfigPaths titlePath;
        Location loc;
        ConfigManager config = ((BunnyHomes)this.getPlugin()).getConfigManager();
        boolean isSet = ((BunnyHomes)this.getPlugin()).getHomeManager().isSet(String.valueOf(this.owner.getUniqueId()) + "." + slot);
        boolean hasPerm = this.owner.hasPermission(((BunnyHomes)this.getPlugin()).getConfigManager().getString(ConfigPaths.PERMISSION_HOME) + "." + slot);
        ItemStackBuilder bed = hasPerm ? (isSet ? new ItemStackBuilder(Material.PURPLE_BED) : new ItemStackBuilder(Material.LIGHT_GRAY_BED)) : new ItemStackBuilder(Material.RED_BED);
        bed.hideAttributes();
        Home home = ((BunnyHomes)this.getPlugin()).getHomeManager().getHome(this.owner.getUniqueId(), slot);
        Location location = loc = home == null ? this.owner.getLocation() : home.getLocation();
        if (isSet) {
            titlePath = ConfigPaths.MESSAGE_INV_HOME_SET_TITLE;
            lorePath = ConfigPaths.MESSAGE_INV_HOME_SET_LORE;
        } else if (hasPerm) {
            titlePath = ConfigPaths.MESSAGE_INV_HOME_NOTSET_TITLE;
            lorePath = ConfigPaths.MESSAGE_INV_HOME_NOTSET_LORE;
        } else {
            titlePath = ConfigPaths.MESSAGE_INV_HOME_NOPERM_TITLE;
            int two = 2;
            int three = 3;
            int four = 4;
            int five = 5;
            int six = 6;
            int seven = 7;
            lorePath = switch (slot) {
                case 2 -> ConfigPaths.MESSAGE_INV_HOME_NOPERM_LORE_2;
                case 3 -> ConfigPaths.MESSAGE_INV_HOME_NOPERM_LORE_3;
                case 4 -> ConfigPaths.MESSAGE_INV_HOME_NOPERM_LORE_4;
                case 5 -> ConfigPaths.MESSAGE_INV_HOME_NOPERM_LORE_5;
                case 6 -> ConfigPaths.MESSAGE_INV_HOME_NOPERM_LORE_6;
                case 7 -> ConfigPaths.MESSAGE_INV_HOME_NOPERM_LORE_7;
                default -> ConfigPaths.MESSAGE_INV_HOME_NOPERM_LORE_1;
            };
        }
        bed.setName(config.getString(titlePath).replace("%HOME_NAME%", (CharSequence)(home == null ? "Home " + slot : home.getName())).replace("&", "\u00a7"));
        if (loc.getWorld() == null) {
            return null;
        }
        List<String> lore = config.getStringList(lorePath).stream().map(s -> s.replace("%WORLD_NAME%", loc.getWorld().getName()).replace("%LOC_X%", String.valueOf(loc.getBlockX())).replace("%LOC_Y%", String.valueOf(loc.getBlockY())).replace("%LOC_Z%", String.valueOf(loc.getBlockZ())).replace("&", "\u00a7")).toList();
        bed.setLore(lore);
        return bed.getItemStack();
    }

    protected void doClick(Player player, int i, InventoryClickEvent inventoryClickEvent) {
        ConfirmInventory confirm;
        ConfigManager config = ((BunnyHomes)this.getPlugin()).getConfigManager();
        int homeIndex = i % 9;
        if (!this.owner.hasPermission(config.getString(ConfigPaths.PERMISSION_HOME) + "." + homeIndex)) {
            return;
        }
        if (9 < i && i < 17) {
            Home home = ((BunnyHomes)this.getPlugin()).getHomeManager().getHome(this.owner.getUniqueId(), homeIndex);
            if (home == null) {
                return;
            }
            player.closeInventory();
            player.teleport(home.getLocation());
            player.playSound((Entity)player, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            player.sendMessage(config.getString(ConfigPaths.MESSAGE_PLAYER_TELEPORT).replace("&", "\u00a7"));
        }
        if (18 < i && i < 26) {
            confirm = this.getConfirmSetInventory(player, i, homeIndex);
            confirm.openInventory(player);
        }
        if (27 < i && i < 35) {
            confirm = this.getConfirmDelInventory(player, i, homeIndex);
            confirm.openInventory(player);
        }
    }

    @NotNull
    private ConfirmInventory getConfirmSetInventory(Player player, int i, int homeIndex) {
        ConfigManager config = ((BunnyHomes)this.getPlugin()).getConfigManager();
        Location loc = player.getLocation();
        String homeName = "Home " + homeIndex;
        Home home = new Home(this.owner, loc, "Home " + homeIndex);
        return new ConfirmInventory((BunnyHomes)this.getPlugin(), "\u00a72" + homeName + " setzen?", () -> {
            try {
                ((BunnyHomes)this.getPlugin()).getHomeManager().saveHome(home, homeIndex);
                this.getInv().setItem(i - 9, this.getBed(homeIndex));
                player.sendMessage(config.getString(ConfigPaths.MESSAGE_PLAYER_SETHOME).replace("&", "\u00a7"));
                player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
            }
            catch (IOException e) {
                ((BunnyHomes)this.getPlugin()).getLogger().severe("Fehler beim Schreiben in eine Configdatei");
                throw new RuntimeException(e);
            }
        }, () -> this.openInventory(player));
    }

    @NotNull
    private ConfirmInventory getConfirmDelInventory(Player player, int i, int homeIndex) {
        ConfigManager config = ((BunnyHomes)this.getPlugin()).getConfigManager();
        String homeName = "Home " + homeIndex;
        return new ConfirmInventory((BunnyHomes)this.getPlugin(), "\u00a7c" + homeName + " l\u00f6schen?", () -> {
            try {
                ((BunnyHomes)this.getPlugin()).getHomeManager().delHome(this.owner.getUniqueId(), homeIndex);
                this.getInv().setItem(i - 18, this.getBed(homeIndex));
                player.sendMessage(config.getString(ConfigPaths.MESSAGE_PLAYER_DELHOME).replace("&", "\u00a7"));
                player.playSound((Entity)player, Sound.BLOCK_ANVIL_DESTROY, 1.0f, 1.0f);
            }
            catch (IOException e) {
                ((BunnyHomes)this.getPlugin()).getLogger().severe("Fehler beim Schreiben in eine Configdatei");
                throw new RuntimeException(e);
            }
        }, () -> this.openInventory(player));
    }

    protected void onClose(Player player) {
    }
}

