/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.citymobcontrol;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CityMobControl
extends JavaPlugin
implements Listener {
    private static final String TARGET_WORLD = "city";
    private static final String PERMISSION = "fl.mobs.interact";

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("CityMobControl aktiviert.");
    }

    private boolean isInCityWorld(Entity entity) {
        World world = entity.getWorld();
        return world != null && world.getName().equalsIgnoreCase(TARGET_WORLD);
    }

    private boolean hasPermission(Player player) {
        return player.hasPermission(PERMISSION);
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (this.isInCityWorld((Entity)event.getEntity()) && event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityInteract(PlayerInteractEntityEvent event) {
        if (this.isInCityWorld(event.getRightClicked()) && !this.hasPermission(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerShear(PlayerShearEntityEvent event) {
        if (this.isInCityWorld(event.getEntity()) && !this.hasPermission(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByPlayer(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (this.isInCityWorld(event.getEntity()) && !this.hasPermission(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityBreed(EntityBreedEvent event) {
        if (this.isInCityWorld((Entity)event.getEntity())) {
            event.setCancelled(true);
        }
    }
}

