/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.fllobbytemp;

import de.flipper1406.fllobbytemp.FLLobbyTemp;
import de.flipper1406.fllobbytemp.UserManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class FutureListener
implements Listener {
    private final FLLobbyTemp plugin;

    public FutureListener(FLLobbyTemp plugin) {
        this.plugin = plugin;
    }

    public boolean isEventActive() {
        return this.plugin.getConfigManager().getConfig().getBoolean("event.aktiv");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Location randomLoc;
        event.getPlayer().setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        event.getPlayer().setGameMode(GameMode.ADVENTURE);
        event.getPlayer().getInventory().clear();
        event.getPlayer().setHealth(20.0);
        event.getPlayer().setSaturation(20.0f);
        event.setJoinMessage(null);
        UserManager.setupPlayerData(event.getPlayer());
        String ip = event.getPlayer().getAddress().getHostName();
        Object region = "Unbekannt";
        try {
            String inputLine;
            URL url = new URL("http://ip-api.com/json/" + ip);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(response.toString());
            String country = (String)json.get((Object)"country");
            String regionName = (String)json.get((Object)"regionName");
            String city = (String)json.get((Object)"city");
            String isp = (String)json.get((Object)"isp");
            region = "Land: " + country + " Region: " + regionName + " Stadt: " + city + " ISP: " + isp;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UserManager.setRegion(event.getPlayer().getUniqueId(), (String)region);
        UserManager.updateData(event.getPlayer());
        if (this.isEventActive() && (randomLoc = this.getRandomLocation("event")) != null) {
            event.getPlayer().teleport(randomLoc);
            event.getPlayer().sendMessage("\u00a72<>========= \u00a7aFutureLeague \u00a72=========<>");
            event.getPlayer().sendMessage("");
            event.getPlayer().sendMessage("\u00a72Aktuell ist ein Event aktiv, welches am 20. Oktober und am 21 Oktober jeweils gegen 20 Uhr startet!");
            event.getPlayer().sendMessage("\u00a72W\u00e4hrend dieser zwei Tage bekommst du schon mal einen kleinen Einblick auf die zuk\u00fcnftige Map!");
            event.getPlayer().sendMessage("\u00a72Dabei erh\u00e4lst du beim Joinen eine von 4 Ausschnitten, welche zuf\u00e4llig vergeben werden! Au\u00dferdem kannst du mit /spawn zu einem dieser 4 Spawnpunkte zur\u00fcckkehren.");
            event.getPlayer().sendMessage("\u00a72F\u00fcr alle weiteren Infos rund um das Event, schau in unserem Discord nach: https://www.futureleague.de/discord/");
            event.getPlayer().sendMessage("\u00a72<>=============<>");
            return;
        }
        Location fallback = this.getRandomLocation("");
        event.getPlayer().teleport(fallback);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> event.getPlayer().teleport(fallback), 20L);
        if (!event.getPlayer().hasPermission("fl.team")) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (event.getPlayer().isOnline()) {
                    event.getPlayer().sendMessage("\u00a72<><><>\u00a7a FutureLeague \u00a72<><><>");
                    event.getPlayer().sendMessage("");
                    event.getPlayer().sendMessage("\u00a7aDu kannst gut bauen und bist kreativ? Dann suchen wir dich f\u00fcr unser Bauteam!");
                    event.getPlayer().sendMessage("\u00a7aWir freuen uns auf eine Bewerbung im Discord!");
                    event.getPlayer().sendMessage("");
                    event.getPlayer().sendMessage("\u00a7ehttps://www.futureleague.de/discord/");
                    event.getPlayer().sendMessage("");
                    event.getPlayer().sendMessage("\u00a72<><><><><><><><><><><><>");
                }
            }, 400L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (event.getPlayer().isOnline()) {
                    event.getPlayer().sendMessage("\u00a72<><><>\u00a7a FutureLeague \u00a72<><><>");
                    event.getPlayer().sendMessage("");
                    event.getPlayer().sendMessage("\u00a7a Besuch uns auch auf unseren sozialen Netzwerken!");
                    event.getPlayer().sendMessage("");
                    event.getPlayer().sendMessage("\u00a76[Discord]");
                    event.getPlayer().sendMessage("\u00a7ehttps://www.futureleague.de/discord/");
                    event.getPlayer().sendMessage("");
                    event.getPlayer().sendMessage("\u00a76[Website]");
                    event.getPlayer().sendMessage("\u00a7ehttps://www.futureleague.de/");
                    event.getPlayer().sendMessage("");
                    event.getPlayer().sendMessage("\u00a72<><><><><><><><><><><><>");
                }
            }, 800L);
        }
    }

    @EventHandler
    public void onPlayerChatEvent(AsyncPlayerChatEvent event) {
        String prefix = "\u00a72[Spieler] ";
        if (event.getPlayer().getName().equals("flipper1406")) {
            prefix = "\u00a74[Admin] ";
        } else if (event.getPlayer().getName().equals("BunnyKick")) {
            prefix = "\u00a79[Dev-\u00a77Leitung] \u00a79 ";
        } else if (event.getPlayer().getName().equals("Luccaopa")) {
            prefix = "\u00a79[Bau-\u00a73Leitung] ";
        } else if (event.getPlayer().getName().equals("DerSchoreHD") || event.getPlayer().getName().equals("TigerFire5")) {
            prefix = "\u00a75[Moderator] ";
        }
        String worldName = event.getPlayer().getWorld().getName();
        String worldPrefix = "";
        switch (worldName) {
            case "preview_void_1": {
                worldPrefix = "\u00a7a[Krankenhaus] ";
                break;
            }
            case "preview_void_2": {
                worldPrefix = "\u00a7a[Flughafen] ";
                break;
            }
            case "preview_void_3": {
                worldPrefix = "\u00a7a[Stadtpark] ";
                break;
            }
            case "preview_void_4": {
                worldPrefix = "\u00a7a[Altes Dorf] ";
                break;
            }
            default: {
                worldPrefix = "";
            }
        }
        String message = worldPrefix + prefix + event.getPlayer().getName() + " \u00a74>> \u00a7r" + event.getMessage();
        this.broadcastMessage(message);
        event.setCancelled(true);
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        event.getWorld().setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
    }

    public void broadcastMessage(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(message);
        }
        Bukkit.getConsoleSender().sendMessage(message);
    }

    public Location getRandomLocation(String info) {
        if (info.equalsIgnoreCase("event")) {
            ArrayList<Location> locations = new ArrayList<Location>();
            locations.add(new Location(Bukkit.getWorld((String)"preview_void_1"), 17.0, 105.0, -137.0, -75.0f, 0.0f));
            locations.add(new Location(Bukkit.getWorld((String)"preview_void_2"), -392.5, 103.0, 204.0, 90.0f, 0.0f));
            locations.add(new Location(Bukkit.getWorld((String)"preview_void_3"), -19.0, 105.0, -142.0, 39.0f, 0.0f));
            locations.add(new Location(Bukkit.getWorld((String)"preview_void_4"), -219.5, 105.0, 373.5, -90.0f, 0.0f));
            List valid = locations.stream().filter(loc -> loc.getWorld() != null).collect(Collectors.toList());
            if (valid.isEmpty()) {
                return null;
            }
            return (Location)valid.get(ThreadLocalRandom.current().nextInt(valid.size()));
        }
        Location returnLocation = this.getLocationBasedOnDate(LocalDate.now());
        return returnLocation;
    }

    private Location getLocationBasedOnDate(LocalDate today) {
        Location returnLocation = new Location(Bukkit.getWorld((String)"Hub2_normal"), 127.5, 57.0, -13.5, 0.0f, 0.0f);
        LocalDate startDateHalloween = LocalDate.of(today.getYear(), Month.OCTOBER, 20);
        LocalDate endDateHalloween = LocalDate.of(today.getYear(), Month.NOVEMBER, 3);
        if (!today.isBefore(startDateHalloween) && !today.isAfter(endDateHalloween)) {
            returnLocation = new Location(Bukkit.getWorld((String)"Hub2_halloween"), 127.5, 57.0, -13.5, 0.0f, 0.0f);
        }
        LocalDate startDateXMas = LocalDate.of(today.getYear(), Month.DECEMBER, 6);
        LocalDate endDateXMas = LocalDate.of(today.getYear(), Month.DECEMBER, 31);
        if (!today.isBefore(startDateXMas) && !today.isAfter(endDateXMas)) {
            returnLocation = new Location(Bukkit.getWorld((String)"Hub2_xmas"), 127.5, 57.0, -13.5, 0.0f, 0.0f);
        }
        int year = today.getYear();
        LocalDate easterSunday = FutureListener.calculateEaster(year);
        LocalDate oneWeekBeforeEaster = easterSunday.minus(1L, ChronoUnit.WEEKS);
        LocalDate oneWeekAfterEaster = easterSunday.plus(1L, ChronoUnit.WEEKS);
        if ((today.isEqual(oneWeekBeforeEaster) || today.isAfter(oneWeekBeforeEaster)) && (today.isEqual(oneWeekAfterEaster) || today.isBefore(oneWeekAfterEaster))) {
            returnLocation = new Location(Bukkit.getWorld((String)"Hub2_easter"), 127.5, 57.0, -13.5, 0.0f, 0.0f);
        }
        return returnLocation;
    }

    public static LocalDate calculateEaster(int year) {
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * l) / 451;
        int month = (h + l - 7 * m + 114) / 31;
        int day = (h + l - 7 * m + 114) % 31 + 1;
        return LocalDate.of(year, month, day);
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        event.setQuitMessage(null);
    }
}

