/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.fllobbytemp;

import de.flipper1406.fllobbytemp.FLLobbyTemp;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class UserManager {
    private static FLLobbyTemp plugin;

    public static void init(FLLobbyTemp pluginInstance) {
        plugin = pluginInstance;
    }

    public static File getDataFolder() {
        return new File(plugin.getDataFolder(), "Playerdata");
    }

    public static File getPlayerFile(UUID uuid) {
        return new File(UserManager.getDataFolder(), uuid.toString() + "/playerdata.yml");
    }

    public static void savePlayerConfig(UUID uuid, FileConfiguration config) {
        try {
            config.save(UserManager.getPlayerFile(uuid));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setupPlayerData(Player player) {
        UUID uuid = player.getUniqueId();
        File playerFolder = new File(UserManager.getDataFolder(), uuid.toString());
        if (!playerFolder.exists()) {
            playerFolder.mkdirs();
        }
        try {
            File playerFile = UserManager.getPlayerFile(uuid);
            if (!playerFile.exists()) {
                playerFile.createNewFile();
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
                config.set("Username", (Object)player.getName());
                config.set("lastKnownIPs", new ArrayList());
                config.set("region", (Object)"Unknown");
                config.save(playerFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setRegion(UUID uuid, String region) {
        FileConfiguration config = UserManager.getPlayerConfig(uuid);
        config.set("region", (Object)region);
        UserManager.savePlayerConfig(uuid, config);
    }

    public static FileConfiguration getPlayerConfig(UUID uuid) {
        return YamlConfiguration.loadConfiguration((File)UserManager.getPlayerFile(uuid));
    }

    public static void updateData(Player player) {
        String ip;
        UUID uuid = player.getUniqueId();
        FileConfiguration config = UserManager.getPlayerConfig(uuid);
        List<String> knownIPs = config.getStringList("lastKnownIPs");
        if (!knownIPs.contains(ip = player.getAddress().getAddress().getHostAddress())) {
            knownIPs.add(0, ip);
            if (knownIPs.size() > 10) {
                knownIPs = knownIPs.subList(0, 10);
            }
        }
        config.set("lastKnownIPs", (Object)knownIPs);
        UserManager.savePlayerConfig(uuid, config);
    }
}

