/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.fl_testserver.maps;

import de.flipper1406.fl_testserver.FL_Testserver;
import de.flipper1406.fl_testserver.maps.MapsManager;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MapsGUI
implements Listener {
    private final FL_Testserver plugin;
    private final MapsManager mapsManager;
    private final String MAIN_TITLE = "\u00a7aServer ausw\u00e4hlen";
    private final String MAPS_TITLE = "\u00a7aMaps von ";

    public MapsGUI(MapsManager manager, FL_Testserver plugin) {
        this.mapsManager = manager;
        this.plugin = plugin;
    }

    public void openMain(Player p) {
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)"\u00a7aServer ausw\u00e4hlen");
        inv.setItem(3, this.createItem(Material.BEACON, "\u00a7bLobby"));
        inv.setItem(5, this.createItem(Material.EMERALD, "\u00a7aWirtschaft"));
        p.openInventory(inv);
    }

    public void openMapsForServer(Player p, String server) {
        List<MapsManager.MapData> maps = this.mapsManager.getMapsByServer(server);
        int size = ((maps.size() - 1) / 9 + 1) * 9;
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)("\u00a7aMaps von " + server));
        for (MapsManager.MapData map : maps) {
            inv.addItem(new ItemStack[]{this.createItem(map.icon, "\u00a7e" + map.name)});
        }
        p.openInventory(inv);
    }

    private ItemStack createItem(Material mat, String name) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        String serverName;
        MapsManager.MapData map;
        if (e.getCurrentItem() == null) {
            return;
        }
        if (!e.getCurrentItem().hasItemMeta()) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        String rawTitle = e.getView().getTitle();
        String title = ChatColor.stripColor((String)rawTitle);
        String name = ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName());
        e.setCancelled(true);
        if (title.equalsIgnoreCase("Server ausw\u00e4hlen")) {
            if (name.equalsIgnoreCase("Lobby")) {
                this.openMapsForServer(p, "Lobby");
                return;
            }
            if (name.equalsIgnoreCase("Wirtschaft")) {
                this.openMapsForServer(p, "Wirtschaft");
                return;
            }
        }
        if (title.startsWith("Maps von ") && (map = (MapsManager.MapData)this.mapsManager.getMapsByServer(serverName = title.replace("Maps von ", "")).stream().filter(m -> m.name.equalsIgnoreCase(name)).findFirst().orElse(null)) != null) {
            p.teleport(map.spawn);
            p.sendMessage("\u00a7aTeleportiert zur Map \u00a7e" + map.name);
            p.closeInventory();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> p.setGameMode(GameMode.CREATIVE), 10L);
        }
    }
}

