/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.fl_testserver.maps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MapsManager {
    private final File file;
    private FileConfiguration config;
    private final Map<String, MapData> maps = new HashMap<String, MapData>();

    public MapsManager() {
        this.file = new File("plugins/FL_Testserver", "maps.yml");
        this.createFileIfNotExists();
        this.load();
    }

    private void createFileIfNotExists() {
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
                this.config = YamlConfiguration.loadConfiguration((File)this.file);
                this.config.set("maps.exampleMap.server", (Object)"Lobby");
                this.config.set("maps.exampleMap.world", (Object)"world");
                this.config.set("maps.exampleMap.x", (Object)0);
                this.config.set("maps.exampleMap.y", (Object)100);
                this.config.set("maps.exampleMap.z", (Object)0);
                this.config.set("maps.exampleMap.yaw", (Object)0);
                this.config.set("maps.exampleMap.pitch", (Object)0);
                this.config.set("maps.exampleMap.icon", (Object)"STONE");
                this.config.save(this.file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void load() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        if (!this.config.isConfigurationSection("maps")) {
            return;
        }
        for (String key : this.config.getConfigurationSection("maps").getKeys(false)) {
            String base = "maps." + key;
            String server = this.config.getString(base + ".server");
            String world = this.config.getString(base + ".world");
            double x = this.config.getDouble(base + ".x");
            double y = this.config.getDouble(base + ".y");
            double z = this.config.getDouble(base + ".z");
            float yaw = (float)this.config.getDouble(base + ".yaw");
            float pitch = (float)this.config.getDouble(base + ".pitch");
            Material icon = Material.matchMaterial((String)this.config.getString(base + ".icon", "MAP"));
            Location spawn = new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
            this.maps.put(key, new MapData(key, server, spawn, icon));
        }
    }

    public List<MapData> getMapsByServer(String serverName) {
        ArrayList<MapData> list = new ArrayList<MapData>();
        for (MapData data : this.maps.values()) {
            if (!data.server.equalsIgnoreCase(serverName)) continue;
            list.add(data);
        }
        return list;
    }

    public static class MapData {
        public final String name;
        public final String server;
        public final Location spawn;
        public final Material icon;

        public MapData(String name, String server, Location spawn, Material icon) {
            this.name = name;
            this.server = server;
            this.spawn = spawn;
            this.icon = icon != null ? icon : Material.MAP;
        }
    }
}

