/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.fl_testserver.warps;

import de.flipper1406.fl_testserver.warps.WarpManager;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpCommand
implements CommandExecutor {
    private final WarpManager warpManager;

    public WarpCommand(WarpManager warpManager) {
        this.warpManager = warpManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Nur Spieler k\u00f6nnen diesen Befehl ausf\u00fchren.");
            return false;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase()) {
            case "setwarp": {
                if (args.length == 1) {
                    String warpName = args[0];
                    Location loc = player.getLocation();
                    this.warpManager.addWarp(warpName, loc);
                    player.sendMessage("Warp '" + warpName + "' wurde gesetzt!");
                    break;
                }
                player.sendMessage("\u00a7cBitte benutze /warp <Name>, /setwarp <Name>, oder /delwarp <Name>.");
                break;
            }
            case "delwarp": {
                if (args.length == 1) {
                    String warpName = args[0];
                    this.warpManager.removeWarp(warpName);
                    player.sendMessage("\u00a72Warp \u00a7a'" + warpName + "' \u00a72wurde gel\u00f6scht!");
                    break;
                }
                player.sendMessage("\u00a7cBitte benutze /warp <Name>, /setwarp <Name>, oder /delwarp <Name>.");
                break;
            }
            case "warp": {
                if (args.length == 1) {
                    String warpName = args[0];
                    if (this.warpManager.teleportToWarp(player, warpName)) {
                        player.sendMessage("\u00a72Teleportiert zu Warp \u00a7a'" + warpName + "'");
                        break;
                    }
                    player.sendMessage("\u00a7cWarp \u00a74'" + warpName + "'\u00a7c existiert nicht.");
                    break;
                }
                player.sendMessage("\u00a7cBitte benutze /warp <Name>, /setwarp <Name>, oder /delwarp <Name>.");
                break;
            }
            case "warps": {
                Map<String, Location> warpsMap = this.warpManager.getWarps();
                if (warpsMap.isEmpty()) {
                    player.sendMessage("\u00a72Es gibt keine gespeicherten Warps.");
                    break;
                }
                player.sendMessage("\u00a7aVerf\u00fcgbare Warps:");
                String[] warps = warpsMap.keySet().toArray(new String[0]);
                int itemsPerPage = 10;
                int totalPages = (int)Math.ceil((double)warps.length / (double)itemsPerPage);
                int page = 1;
                int startIndex = (page - 1) * itemsPerPage;
                int endIndex = Math.min(startIndex + itemsPerPage, warps.length);
                for (int i = startIndex; i < endIndex; ++i) {
                    String warpName = warps[i];
                    TextComponent warpText = new TextComponent("\u00a77- " + warpName);
                    warpText.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/warp " + warpName));
                    warpText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Klicke hier, um zu diesem Warp zu teleportieren")}));
                    player.spigot().sendMessage((BaseComponent)warpText);
                }
                player.sendMessage("\u00a7aSeite " + page + " von " + totalPages);
                break;
            }
            default: {
                player.sendMessage("\u00a7cBitte benutze /warp <Name>, /setwarp <Name>, oder /delwarp <Name>.");
                return false;
            }
        }
        return true;
    }
}

