/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.fl_testserver.warps;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class WarpManager {
    private final File file = new File("plugins/FL_Testserver", "warps.yml");
    private FileConfiguration config;
    private final Map<String, Location> warps = new HashMap<String, Location>();

    public WarpManager() {
        this.loadWarps();
    }

    public void loadWarps() {
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        for (String key : this.config.getKeys(false)) {
            String worldName = this.config.getString(key + ".world");
            double x = this.config.getDouble(key + ".x");
            double y = this.config.getDouble(key + ".y");
            double z = this.config.getDouble(key + ".z");
            float yaw = (float)this.config.getDouble(key + ".yaw");
            float pitch = (float)this.config.getDouble(key + ".pitch");
            World world = Bukkit.getWorld((String)worldName);
            Location location = new Location(world, x, y, z, yaw, pitch);
            this.warps.put(key, location);
        }
    }

    public void saveWarps() {
        for (Map.Entry<String, Location> entry : this.warps.entrySet()) {
            String key = entry.getKey();
            Location loc = entry.getValue();
            this.config.set(key + ".world", (Object)loc.getWorld().getName());
            this.config.set(key + ".x", (Object)loc.getX());
            this.config.set(key + ".y", (Object)loc.getY());
            this.config.set(key + ".z", (Object)loc.getZ());
            this.config.set(key + ".yaw", (Object)Float.valueOf(loc.getYaw()));
            this.config.set(key + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addWarp(String name, Location location) {
        this.warps.put(name, location);
        this.saveWarps();
    }

    public void removeWarp(String name) {
        this.warps.remove(name);
        this.saveWarps();
    }

    public boolean teleportToWarp(Player player, String name) {
        Location location = this.warps.get(name);
        if (location != null) {
            player.teleport(location);
            return true;
        }
        return false;
    }

    public Map<String, Location> getWarps() {
        return this.warps;
    }
}

