/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.ConfigManager;

import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFilePath;
import de.flipper1406.futureleague_wirtschaft.FutureLeague_Wirtschaft;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigFileConfig {
    private File file;
    private FileConfiguration config;
    private FutureLeague_Wirtschaft plugin;

    public ConfigFileConfig(FutureLeague_Wirtschaft plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "config.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.load();
    }

    public void load() {
        if (!this.file.exists()) {
            this.config.options().copyDefaults(true);
            Location loc = new Location(Bukkit.getWorld((String)"mine"), 0.0, 80.0, 0.0);
            this.config.addDefault(ConfigFilePath.DATABASE_DB.getPath(), (Object)"d0411da5");
            this.config.addDefault(ConfigFilePath.DATABASE_HOST.getPath(), (Object)"85.13.138.22");
            this.config.addDefault(ConfigFilePath.DATABASE_PORT.getPath(), (Object)"3306");
            this.config.addDefault(ConfigFilePath.DATABASE_USER.getPath(), (Object)"User");
            this.config.addDefault(ConfigFilePath.DATABASE_PASSWORD.getPath(), (Object)"Password");
            this.config.addDefault("counter", (Object)0);
            this.config.addDefault("pvpWorld", (Object)"pvp");
            this.config.addDefault("standardEffectDuration", (Object)3);
            this.config.addDefault("minespawn", (Object)loc);
            this.save();
        } else {
            try {
                this.config.load(this.file);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getIntValue(String path) {
        return this.config.getInt(path);
    }

    public String getStringValue(String path) {
        return this.config.getString(path);
    }

    public Location getLocation(String path) {
        return this.config.getLocation(path);
    }

    public void setLocation(String path, Location userLoc) {
        this.config.set(path, (Object)userLoc);
        this.save();
    }

    public void setInt(String path, int number) {
        this.config.set(path, (Object)number);
        this.save();
    }
}

