/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools.Elevator;

import de.flipper1406.futureleague_wirtschaft.FutureLeague_Wirtschaft;
import de.flipper1406.futureleague_wirtschaft.Tools.Elevator.Elevator;
import de.flipper1406.futureleague_wirtschaft.Tools.Elevator.ElevatorManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Switch;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ElevatorListener
implements Listener {
    private final ElevatorManager manager;
    private final FutureLeague_Wirtschaft plugin;
    private final Map<Player, Location> openElevatorMap = new HashMap<Player, Location>();

    public ElevatorListener(ElevatorManager manager, FutureLeague_Wirtschaft plugin) {
        this.manager = manager;
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = e.getClickedBlock();
        if (block == null || !(block.getBlockData() instanceof Switch)) {
            return;
        }
        if (!this.manager.elevatorExists(block.getLocation())) {
            return;
        }
        e.setCancelled(true);
        Player player = e.getPlayer();
        List<Elevator> elevators = this.manager.getElevatorsOnXZ(block.getX(), block.getZ(), block.getWorld());
        int size = 0;
        if (elevators.size() <= 9) {
            size = 9;
        } else if (elevators.size() <= 18) {
            size = 18;
        } else if (elevators.size() <= 27) {
            size = 27;
        }
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)"\u00a76Aufzug w\u00e4hlen");
        for (int i = 0; i < elevators.size(); ++i) {
            Elevator el = elevators.get(i);
            ItemStack item = new ItemStack(Material.ENDER_PEARL);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7e" + el.getName() + " \u00a77(Y: " + el.getButtonLocation().getBlockY() + ")");
            item.setItemMeta(meta);
            gui.setItem(i, item);
        }
        this.openElevatorMap.put(player, block.getLocation());
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        final Player player = (Player)humanEntity;
        if (!e.getView().getTitle().contains("Aufzug")) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        final String name = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName().replaceAll(" \u00a77\\(Y:.*?\\)", ""));
        Location buttonLoc = this.openElevatorMap.get(player);
        if (buttonLoc == null) {
            player.sendMessage("\u00a7cFehler: Keine Aufzugsposition gefunden.");
            return;
        }
        List<Elevator> elevators = this.manager.getElevatorsOnXZ(buttonLoc.getBlockX(), buttonLoc.getBlockZ(), buttonLoc.getWorld());
        for (final Elevator el : elevators) {
            if (!el.getName().equals(name)) continue;
            double differenceLevel = el.getTeleportLocation().getY() - player.getLocation().getY();
            if (differenceLevel < 0.0) {
                differenceLevel *= -1.0;
            }
            int delay = Math.round(Math.round(differenceLevel) / 10L + 3L);
            player.closeInventory();
            this.openElevatorMap.remove(player);
            this.applyBlindnessEffect(player, delay);
            player.playSound(player.getLocation(), Sound.ENTITY_MINECART_INSIDE, 5.0f, 1.0f);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.teleport(el.getTeleportLocation());
                    player.sendMessage("\u00a7aTeleportiert zu \u00a7e" + name);
                }
            }, (long)(20 * delay));
            return;
        }
    }

    public void applyBlindnessEffect(Player target, int duration) {
        int durationInSecconds = 20 * (duration + 2);
        int amplifier = 20;
        target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, durationInSecconds, amplifier));
    }
}

