/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.General;

import de.flipper1406.futureleague_wirtschaft.Constants;
import java.util.Map;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class NameTag
implements Listener {
    private final Plugin plugin;
    private final LuckPerms luckPerms;

    public NameTag(Plugin plugin) {
        this.plugin = plugin;
        this.luckPerms = LuckPermsProvider.get();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.luckPerms.getUserManager().loadUser(player.getUniqueId()).thenAcceptAsync(user -> {
            String primaryGroup = user.getPrimaryGroup().toLowerCase();
            ChatColor color = Constants.GROUP_COLORS.getOrDefault(primaryGroup, ChatColor.WHITE);
            Map<String, String> rankPrefixes = Map.of("admin", "[Admin]", "moderator", "[Mod]", "vip", "[VIP]", "spieler", "[Spieler]", "bauleitung", "[Bau-Leitung]", "devleitung", "[Dev-Leitung]");
            String prefix = rankPrefixes.getOrDefault(primaryGroup, "[Spieler]");
            Bukkit.getScheduler().runTask(this.plugin, () -> this.setNametag(player, color, prefix));
        });
    }

    private void setNametag(Player player, ChatColor color, String prefix) {
        String teamName;
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam(teamName = "grp_" + player.getUniqueId().toString().substring(0, 12));
        if (team == null) {
            team = scoreboard.registerNewTeam(teamName);
            team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
        }
        team.setColor(color);
        team.setPrefix(String.valueOf(color) + prefix + " ");
        if (!team.hasEntry(player.getName())) {
            team.addEntry(player.getName());
        }
        player.setScoreboard(scoreboard);
    }
}

