/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Userdata.Events;

import de.flipper1406.futureleague_wirtschaft.Userdata.Utils.UserDataManager;
import de.flipper1406.futureleague_wirtschaft.futureLeagueWirtschaft;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChatInputListener
implements Listener {
    public static final Map<UUID, UUID> awaitingCashAmount = new HashMap<UUID, UUID>();
    private final Map<UUID, Integer> timeoutTasks = new HashMap<UUID, Integer>();
    private final futureLeagueWirtschaft plugin;

    public ChatInputListener(futureLeagueWirtschaft plugin) {
        this.plugin = plugin;
    }

    public void startTimeout(final Player player) {
        final UUID playerUUID = player.getUniqueId();
        if (this.timeoutTasks.containsKey(playerUUID)) {
            Bukkit.getScheduler().cancelTask(this.timeoutTasks.remove(playerUUID).intValue());
        }
        int taskId = new BukkitRunnable(){

            public void run() {
                if (awaitingCashAmount.containsKey(playerUUID)) {
                    awaitingCashAmount.remove(playerUUID);
                    ChatInputListener.this.timeoutTasks.remove(playerUUID);
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Zeit\u00fcberschreitung. Bargeld-\u00dcbertragung abgebrochen.");
                }
            }
        }.runTaskLater((Plugin)this.plugin, 200L).getTaskId();
        this.timeoutTasks.put(playerUUID, taskId);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        double amount;
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (!awaitingCashAmount.containsKey(playerUUID)) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        UUID targetUUID = awaitingCashAmount.remove(playerUUID);
        if (this.timeoutTasks.containsKey(playerUUID)) {
            Bukkit.getScheduler().cancelTask(this.timeoutTasks.remove(playerUUID).intValue());
        }
        try {
            amount = Double.parseDouble(message);
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Ung\u00fcltiger Betrag. Bitte gib eine g\u00fcltige Zahl ein.");
            return;
        }
        if (amount <= 0.0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Der Betrag muss gr\u00f6\u00dfer als 0 sein.");
            return;
        }
        double senderBalance = UserDataManager.getBalance(playerUUID);
        if (senderBalance < amount) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Du hast nicht genug Coins f\u00fcr diese Transaktion.");
            return;
        }
        UserDataManager.setBalance(playerUUID, senderBalance - amount);
        UserDataManager.setBalance(targetUUID, UserDataManager.getBalance(targetUUID) + amount);
        UserDataManager.logTransaction(targetUUID, playerUUID, amount, "Bargeldhandel");
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Du hast erfolgreich " + amount + " Coins als Bargeld an " + String.valueOf(ChatColor.GREEN) + Bukkit.getOfflinePlayer((UUID)targetUUID).getName() + String.valueOf(ChatColor.GREEN) + " gesendet.");
        Player targetPlayer = Bukkit.getPlayer((UUID)targetUUID);
        if (targetPlayer != null && targetPlayer.isOnline()) {
            targetPlayer.sendMessage(String.valueOf(ChatColor.GREEN) + "Du hast " + amount + " Coins als Bargeld von " + String.valueOf(ChatColor.GREEN) + player.getName() + String.valueOf(ChatColor.GREEN) + " erhalten.");
        }
    }
}

