/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class FixPosCommand
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final File positionsFile;
    private final YamlConfiguration positionsConfig;
    private final File logFile;

    public FixPosCommand(JavaPlugin javaPlugin) {
        this.plugin = javaPlugin;
        this.positionsFile = new File(javaPlugin.getDataFolder(), "savePositions.yml");
        this.logFile = new File(javaPlugin.getDataFolder(), "savePositionsLog.yml");
        if (!this.positionsFile.exists()) {
            try {
                this.positionsFile.getParentFile().mkdirs();
                this.positionsFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.positionsConfig = YamlConfiguration.loadConfiguration((File)this.positionsFile);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Dieser Befehl kann nur von einem Spieler ausgef\u00fchrt werden.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1 && args[0].equalsIgnoreCase("set")) {
            if (!player.hasPermission("fl.fixpos.admin")) {
                player.sendMessage("\u00a7cDu hast keine Berechtigung, diesen Befehl auszuf\u00fchren.");
                return true;
            }
            String key = UUID.randomUUID().toString();
            Location loc = player.getLocation();
            this.positionsConfig.set("positions." + key, (Object)loc);
            try {
                this.positionsConfig.save(this.positionsFile);
                player.sendMessage("\u00a7aPosition erfolgreich gespeichert.");
            }
            catch (IOException e) {
                e.printStackTrace();
                player.sendMessage("\u00a7cFehler beim Speichern der Position.");
            }
            return true;
        }
        if (args.length == 0) {
            ConfigurationSection section = this.positionsConfig.getConfigurationSection("positions");
            if (section == null || section.getKeys(false).isEmpty()) {
                player.sendMessage("\u00a7cKeine gespeicherten Positionen gefunden.");
                return true;
            }
            Location currentLoc = player.getLocation();
            Location nearest = null;
            double minDistance = Double.MAX_VALUE;
            for (String key : section.getKeys(false)) {
                double distance;
                Location loc = section.getLocation(key);
                if (loc == null || !loc.getWorld().getName().equals(currentLoc.getWorld().getName()) || !((distance = currentLoc.distanceSquared(loc)) < minDistance)) continue;
                minDistance = distance;
                nearest = loc;
            }
            if (nearest == null) {
                player.sendMessage("\u00a7cKeine passende Position gefunden.");
                return true;
            }
            Location from = player.getLocation();
            player.teleport(nearest);
            player.sendMessage("\u00a7aDu wurdest zur n\u00e4chstgelegenen Position teleportiert.");
            this.logTeleport(player.getName(), from, nearest);
            return true;
        }
        player.sendMessage("\u00a7cUng\u00fcltiger Befehl. Benutzung: /fixpos [set]");
        return true;
    }

    private void logTeleport(String playerName, Location from, Location to) {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String logEntry = String.format("[%s] %s | Von: %s | Nach: %s%n", timestamp, playerName, this.locToString(from), this.locToString(to));
        try {
            this.logFile.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(this.logFile, true);
            writer.write(logEntry);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String locToString(Location loc) {
        return String.format("%s (%.2f, %.2f, %.2f | Yaw: %.2f, Pitch: %.2f)", loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getYaw()), Float.valueOf(loc.getPitch()));
    }
}

