/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    private final JavaPlugin plugin;
    private Connection connection;
    private String host;
    private int port;
    private String database;
    private String username;
    private String password;

    public DatabaseManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfigData();
    }

    private void loadConfigData() {
        this.host = this.plugin.getConfig().getString("database.host", "localhost");
        this.port = this.plugin.getConfig().getInt("database.port", 3306);
        this.database = this.plugin.getConfig().getString("database.db", "minecraft");
        this.username = this.plugin.getConfig().getString("database.user", "root");
        this.password = this.plugin.getConfig().getString("database.password", "");
    }

    public void connect() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return;
        }
        String url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=false&serverTimezone=UTC";
        this.connection = DriverManager.getConnection(url, this.username, this.password);
        this.plugin.getLogger().info("\u2705 MySQL-Datenbank verbunden: " + this.host + ":" + this.port + "/" + this.database);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void disconnect() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.plugin.getLogger().info("\u274c MySQL-Datenbank getrennt.");
        }
    }
}

