/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import de.flipper1406.futureleague_wirtschaft.Permissions.PermissionManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;

public class PermissionCache {
    private final PermissionManager permManager;
    private final HashMap<UUID, HashMap<String, HashSet<String>>> cache = new HashMap();

    public PermissionCache(PermissionManager permManager) {
        this.permManager = permManager;
    }

    public void load(UUID uuid, String server) {
        HashSet<String> perms = this.permManager.getPermissions(uuid.toString(), server);
        this.cache.computeIfAbsent(uuid, k -> new HashMap()).put(server, perms);
    }

    public void clear(UUID uuid) {
        this.cache.remove(uuid);
    }

    public void clearAll() {
        this.cache.clear();
    }

    public boolean hasPermission(UUID uuid, String permission, String server) {
        HashMap<String, HashSet<String>> serverMap = this.cache.get(uuid);
        if (serverMap == null) {
            return false;
        }
        HashSet<String> perms = serverMap.get(server);
        return perms != null && perms.contains(permission);
    }

    public HashSet<String> getPermissions(UUID uuid, String server) {
        HashMap<String, HashSet<String>> serverMap = this.cache.get(uuid);
        if (serverMap == null) {
            return new HashSet<String>();
        }
        return serverMap.getOrDefault(server, new HashSet());
    }
}

