/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import de.flipper1406.futureleague_wirtschaft.Permissions.PermissionCache;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PermissionListener
implements Listener {
    private final PermissionCache cache;

    public PermissionListener(PermissionCache cache) {
        this.cache = cache;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String server = Bukkit.getServer().getName();
        this.cache.load(uuid, server);
        this.cache.getPermissions(uuid, server).forEach(perm -> player.addAttachment(Bukkit.getPluginManager().getPlugin("MyPermissionPlugin")).setPermission(perm, true));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.cache.clear(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String server = Bukkit.getServer().getName();
        String command = event.getMessage().split(" ")[0].substring(1);
        if (!this.cache.hasPermission(uuid, "minecraft." + command, server)) {
            player.sendMessage("\u00a7cDu hast keine Berechtigung f\u00fcr diesen Command auf diesem Server!");
            event.setCancelled(true);
        }
    }
}

