/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import de.flipper1406.futureleague_wirtschaft.Permissions.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;

public class PermissionManager {
    private final DatabaseManager db;

    public PermissionManager(DatabaseManager db) {
        this.db = db;
    }

    public String getRank(String uuid) {
        try {
            Connection conn = this.db.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT rank FROM players WHERE uuid = ?");
            ps.setString(1, uuid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getString("rank");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "default";
    }

    public HashSet<String> getPermissions(String uuid, String server) {
        HashSet<String> perms = new HashSet<String>();
        String rank = this.getRank(uuid);
        try {
            Connection conn = this.db.getConnection();
            PreparedStatement psRank = conn.prepareStatement("SELECT permission FROM permissions WHERE rank = ? AND (server = ? OR server = 'global')");
            psRank.setString(1, rank);
            psRank.setString(2, server);
            ResultSet rsRank = psRank.executeQuery();
            while (rsRank.next()) {
                perms.add(rsRank.getString("permission"));
            }
            PreparedStatement psPlayer = conn.prepareStatement("SELECT permission FROM player_permissions WHERE uuid = ? AND (server = ? OR server = 'global')");
            psPlayer.setString(1, uuid);
            psPlayer.setString(2, server);
            ResultSet rsPlayer = psPlayer.executeQuery();
            while (rsPlayer.next()) {
                perms.add(rsPlayer.getString("permission"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return perms;
    }

    public boolean hasPermission(String uuid, String permission, String server) {
        return this.getPermissions(uuid, server).contains(permission);
    }

    public String getPrefixByRank(String rank) {
        try {
            Connection conn = this.db.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT prefix FROM ranks WHERE name = ?");
            ps.setString(1, rank);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getString("prefix");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getPrefix(String uuid) {
        return this.getPrefixByRank(this.getRank(uuid));
    }
}

