/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.ChestShop;

import de.flipper1406.futureleague_wirtschaft.ChestShop.ChestShop;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;

public class ChestShopLog {
    private static final File logFile = new File(Bukkit.getPluginManager().getPlugin("FutureLeague_Wirtschaft").getDataFolder(), "shoplog.yml");
    private static final YamlConfiguration config = YamlConfiguration.loadConfiguration((File)logFile);

    private static void save() {
        try {
            config.save(logFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void log(String type, ChestShop shop, String extra) {
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        Object entry = String.format("[%s] %s: %s | Item: %s | Preis: %.2f | Ort: %s", time, type, shop.getOwner(), shop.getItem().getType(), shop.getPricePerItem(), ChestShopLog.formatLocation(shop.getChestLocation()));
        if (extra != null) {
            entry = (String)entry + " | " + extra;
        }
        List logs = config.getStringList("logs");
        logs.add(entry);
        config.set("logs", (Object)logs);
        ChestShopLog.save();
    }

    private static String formatLocation(Location loc) {
        return loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public static void logCreate(ChestShop shop) {
        ChestShopLog.log("Shop erstellt", shop, null);
    }

    public static void logRemove(ChestShop shop) {
        ChestShopLog.log("Shop gel\u00f6scht", shop, null);
    }

    public static void logPurchase(ChestShop shop, String buyerName, int amount) {
        ChestShopLog.log("Kauf", shop, "Gekauft von: " + buyerName + " | Menge: " + amount);
    }
}

