/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.ChestShop;

import de.flipper1406.futureleague_wirtschaft.ChestShop.ChestShop;
import de.flipper1406.futureleague_wirtschaft.ChestShop.ChestShopLog;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class ChestShopManager {
    private static final File shopFile = new File(Bukkit.getPluginManager().getPlugin("FutureLeague_Wirtschaft").getDataFolder(), "shopLocations.yml");
    private static final YamlConfiguration shopConfig = YamlConfiguration.loadConfiguration((File)shopFile);
    private static final Map<Location, ChestShop> shopMap = new HashMap<Location, ChestShop>();
    private static final Map<UUID, Integer> playerShopCount = new HashMap<UUID, Integer>();
    private static final File locFile = new File(Bukkit.getPluginManager().getPlugin("FutureLeague_Wirtschaft").getDataFolder(), "shopLocations.yml");
    private static final YamlConfiguration locConfig = YamlConfiguration.loadConfiguration((File)locFile);
    private static final Map<Location, Location> signToChest = new HashMap<Location, Location>();

    public static void registerSign(Location signLoc, Location chestLoc) {
        signToChest.put(signLoc, chestLoc);
        ChestShopManager.saveSignLocation(signLoc, chestLoc);
    }

    private static void saveSignLocation(Location signLoc, Location chestLoc) {
        String key = ChestShopManager.locationToString(chestLoc);
        locConfig.set("shops." + key + ".sign.world", (Object)signLoc.getWorld().getName());
        locConfig.set("shops." + key + ".sign.x", (Object)signLoc.getBlockX());
        locConfig.set("shops." + key + ".sign.y", (Object)signLoc.getBlockY());
        locConfig.set("shops." + key + ".sign.z", (Object)signLoc.getBlockZ());
        try {
            locConfig.save(locFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isProtectedSign(Location loc) {
        return signToChest.containsKey(loc);
    }

    public static Location getSignLocation(Location chestLoc) {
        String key = ChestShopManager.locationToString(chestLoc);
        ConfigurationSection cs = locConfig.getConfigurationSection("shops." + key + ".sign");
        if (cs == null) {
            return null;
        }
        World world = Bukkit.getWorld((String)cs.getString("world"));
        int x = cs.getInt("x");
        int y = cs.getInt("y");
        int z = cs.getInt("z");
        if (world == null) {
            return null;
        }
        return new Location(world, (double)x, (double)y, (double)z);
    }

    public static void removeSign(Location signLoc) {
        signToChest.remove(signLoc);
        for (String key : locConfig.getConfigurationSection("shops").getKeys(false)) {
            int z;
            int y;
            int x;
            World world;
            ConfigurationSection cs = locConfig.getConfigurationSection("shops." + key + ".sign");
            if (cs == null || !signLoc.equals((Object)new Location(world = Bukkit.getWorld((String)cs.getString("world")), (double)(x = cs.getInt("x")), (double)(y = cs.getInt("y")), (double)(z = cs.getInt("z"))))) continue;
            locConfig.set("shops." + key + ".sign", null);
            try {
                locConfig.save(locFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    public static void registerShop(ChestShop shop) {
        shopMap.put(shop.getChestLocation(), shop);
        playerShopCount.put(shop.getOwner(), ChestShopManager.getShopCount(shop.getOwner()) + 1);
        ChestShopLog.logCreate(shop);
        ChestShopManager.saveLocation(shop.getChestLocation(), shop);
    }

    public static void removeShop(Location location) {
        ChestShop shop = shopMap.remove(location);
        if (shop != null) {
            playerShopCount.put(shop.getOwner(), ChestShopManager.getShopCount(shop.getOwner()) - 1);
            ChestShopLog.logRemove(shop);
            ChestShopManager.removeLocation(location);
        }
    }

    private static void removeLocation(Location loc) {
        String key = ChestShopManager.locationToString(loc);
        locConfig.set("shops." + key, null);
        try {
            locConfig.save(locFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveShops() {
        shopConfig.set("shops", null);
        int i = 0;
        for (ChestShop shop : shopMap.values()) {
            String path = "shops." + i;
            shopConfig.set(path + ".owner", (Object)shop.getOwner().toString());
            shopConfig.set(path + ".world", (Object)shop.getChestLocation().getWorld().getName());
            shopConfig.set(path + ".x", (Object)shop.getChestLocation().getBlockX());
            shopConfig.set(path + ".y", (Object)shop.getChestLocation().getBlockY());
            shopConfig.set(path + ".z", (Object)shop.getChestLocation().getBlockZ());
            shopConfig.set(path + ".price", (Object)shop.getPricePerItem());
            shopConfig.set(path + ".item", (Object)shop.getItem());
            List<String> staffUUIDs = shop.getStaff().stream().map(UUID::toString).toList();
            shopConfig.set(path + ".staff", staffUUIDs);
            ++i;
        }
        try {
            shopConfig.save(shopFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ChestShop getShop(Location location) {
        return shopMap.get(location);
    }

    public static boolean isShop(Location location) {
        return shopMap.containsKey(location);
    }

    public static int getShopCount(UUID uuid) {
        return playerShopCount.getOrDefault(uuid, 0);
    }

    public static Collection<ChestShop> getAllShops() {
        return shopMap.values();
    }

    private static void saveLocation(Location loc, ChestShop shop) {
        String key = ChestShopManager.locationToString(loc);
        locConfig.set("shops." + key + ".world", (Object)loc.getWorld().getName());
        locConfig.set("shops." + key + ".x", (Object)loc.getBlockX());
        locConfig.set("shops." + key + ".y", (Object)loc.getBlockY());
        locConfig.set("shops." + key + ".z", (Object)loc.getBlockZ());
        locConfig.set("shops." + key + ".owner", (Object)shop.getOwner().toString());
        locConfig.set("shops." + key + ".price", (Object)shop.getPricePerItem());
        locConfig.set("shops." + key + ".item", (Object)shop.getItem());
        try {
            locConfig.save(locFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String locationToString(Location loc) {
        return loc.getWorld().getName() + "_" + loc.getBlockX() + "_" + loc.getBlockY() + "_" + loc.getBlockZ();
    }

    public static void loadShops() {
        if (!locFile.exists()) {
            return;
        }
        ConfigurationSection section = locConfig.getConfigurationSection("shops");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection cs = section.getConfigurationSection(key);
            if (cs == null) continue;
            String worldName = cs.getString("world");
            int x = cs.getInt("x");
            int y = cs.getInt("y");
            int z = cs.getInt("z");
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) continue;
            Location loc = new Location(world, (double)x, (double)y, (double)z);
            UUID owner = UUID.fromString(cs.getString("owner"));
            double price = cs.getDouble("price");
            ItemStack item = cs.getItemStack("item");
            ChestShop shop = new ChestShop(owner, loc, item, price);
            shopMap.put(loc, shop);
            playerShopCount.put(owner, ChestShopManager.getShopCount(owner) + 1);
            ConfigurationSection signSection = cs.getConfigurationSection("sign");
            if (signSection == null) continue;
            World signWorld = Bukkit.getWorld((String)signSection.getString("world"));
            int sx = signSection.getInt("x");
            int sy = signSection.getInt("y");
            int sz = signSection.getInt("z");
            if (signWorld == null) continue;
            Location signLoc = new Location(signWorld, (double)sx, (double)sy, (double)sz);
            signToChest.put(signLoc, loc);
        }
    }
}

