/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools;

import de.flipper1406.futureleague_wirtschaft.FutureLeague_Wirtschaft;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class LibaryBooks
implements Listener,
CommandExecutor {
    private final FutureLeague_Wirtschaft plugin;
    private final String configKey = "LibraryLocations";
    private final Map<UUID, ItemStack> receivedBooks = new HashMap<UUID, ItemStack>();
    private final Random random = new Random();

    public LibaryBooks(FutureLeague_Wirtschaft plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        Block clicked = e.getClickedBlock();
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK && clicked != null && clicked.getType() == Material.BOOKSHELF && this.isLibraryBlock(clicked.getLocation())) {
            Location loc = clicked.getLocation().add(0.5, 1.0, 0.5);
            player.getWorld().spawnParticle(Particle.ENCHANT, loc, 30, 0.5, 0.5, 0.5, 0.05);
            player.getWorld().spawnParticle(Particle.PORTAL, loc, 15, 0.3, 0.7, 0.3, 0.02);
            player.getWorld().playSound(loc, Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.2f);
            player.getWorld().playSound(loc, Sound.BLOCK_CHISELED_BOOKSHELF_HIT, 0.6f, 0.8f);
            ItemStack book = this.getRandomSignedBook();
            player.openBook(book);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> player.getInventory().remove(book), 1L);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent e) {
        Player player = e.getPlayer();
        ItemStack current = player.getInventory().getItem(e.getPreviousSlot());
        if (current != null && this.receivedBooks.containsKey(player.getUniqueId())) {
            player.getInventory().remove(this.receivedBooks.get(player.getUniqueId()));
            this.receivedBooks.remove(player.getUniqueId());
        }
    }

    private boolean isLibraryBlock(Location loc) {
        List<Location> saved = this.getLibraryLocations();
        for (Location l : saved) {
            if (!l.equals((Object)loc)) continue;
            return true;
        }
        return false;
    }

    private boolean addLibraryLocation(Location loc, Player player) {
        List<Location> saved = this.getLibraryLocations();
        if (saved == null) {
            saved = new ArrayList<Location>();
        }
        for (Location save : saved) {
            if (!loc.equals((Object)save)) continue;
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Dieses B\u00fccherregal ist bereits registriert.");
            return false;
        }
        saved.add(loc);
        this.plugin.getConfig().set("LibraryLocations", saved);
        this.plugin.saveConfig();
        return true;
    }

    private void removeLibraryLocation(Location loc) {
        List<Location> saved = this.getLibraryLocations();
        saved.removeIf(l -> l.equals((Object)loc));
        this.plugin.getConfig().set("LibraryLocations", saved);
        this.plugin.saveConfig();
    }

    private List<Location> getLibraryLocations() {
        List rawList = this.plugin.getConfig().getList("LibraryLocations");
        ArrayList<Location> locs = new ArrayList<Location>();
        if (rawList != null) {
            for (Object o : rawList) {
                if (!(o instanceof Location)) continue;
                locs.add((Location)o);
            }
        }
        return locs;
    }

    private ItemStack getRandomSignedBook() {
        List<String> titles = Arrays.asList("Kristall-Kolonie", "Die Redstone-B\u00f6rse", "Der Smaragdkrieg", "Zukunft aus Obsidian", "Netherenergie AG", "Aufstieg der Miner-KI", "Handelswege der L\u00fcfte", "KryoTech und die Zeit", "Kristalle und Kompasse", "Schattensplitter GmbH", "Auftrieb bei Flugzeuge");
        ArrayList<List<String>> pages = new ArrayList<List<String>>();
        pages.add(Arrays.asList("Tief in einem vergessenen Gebirge entdeckten Forscher eine H\u00f6hle voller blauer Kristalle. Sie schimmerten selbst im Dunkeln und gaben eine unbekannte Energie ab.", "Die Entdeckung sprach sich schnell herum. Schon bald entstand \u00fcber der H\u00f6hle eine kleine Siedlung, die Kristall-Kolonie. Maschinen wurden gebaut, die mit dieser Energie betrieben wurden.", "Ohne Redstone, ohne Kohle \u2013 alles lief mit Kristallkraft. T\u00fcren \u00f6ffneten sich wie von Geisterhand, Lampen leuchteten ohne Hebel. Die Bewohner glaubten, das Zeitalter des Fortschritts habe begonnen.", "Doch bald wuchsen Pflanzen unnat\u00fcrlich schnell, Tiere wurden aggressiv, und das Wetter spielte verr\u00fcckt. Die Energie war nicht nur stark \u2013 sie ver\u00e4nderte ihre Umgebung.", "Die Kolonie wurde evakuiert. Nur wenige wagten sich sp\u00e4ter zur\u00fcck. Manche sagen, man k\u00f6nne noch immer das Leuchten unter der Erde sehen \u2013 und ein Wispern h\u00f6ren, das niemand erkl\u00e4ren kann.", "Was auch immer die Kristalle wirklich waren \u2013 sie wollten nicht benutzt werden. Oder zumindest nicht auf diese Weise..."));
        pages.add(Arrays.asList("In der Stadt Redspoint war Redstone nicht nur Technik \u2013 es war W\u00e4hrung. H\u00e4ndler spekulierten mit Bl\u00f6cken, Preise \u00e4nderten sich t\u00e4glich. Wer klug investierte, wurde reich.", "Bald entstand die Redstone-B\u00f6rse \u2013 ein prunkvolles Geb\u00e4ude mit Handelsstationen, Leuchttafeln und Mechanismen, die den Markt in Echtzeit anzeigten. Es war ein Wunderwerk aus Technik und Gier.", "Ein junger H\u00e4ndler namens Koril schaffte es, durch gezielte K\u00e4ufe das Angebot zu kontrollieren. Er wurde reich, m\u00e4chtig \u2013 und arrogant.", "Doch eines Tages brach der Markt zusammen. Eine neue Energiequelle \u2013 Kristalle \u2013 verdr\u00e4ngte Redstone langsam vom Markt. Korils Imperium zerfiel schneller, als er es erbaut hatte.", "Er verschwand aus Redspoint. Manche sagen, er lebt in einem unterirdischen Tresorraum, bewacht von Golems, zwischen Tonnen wertlosen Redstones.", "Doch ab und zu taucht eine neue Handelsstrategie auf \u2013 so pr\u00e4zise, so gef\u00e4hrlich \u2013 dass man munkelt: Koril handelt noch. Im Schatten."));
        pages.add(Arrays.asList("Zwei K\u00f6nigreiche lebten lange in Frieden \u2013 bis sie beide eine Smaragdmine an der Grenzlinie beanspruchten. Was mit Verhandlungen begann, endete in Wirtschaftskrieg.", "Beide Seiten \u00fcberboten sich mit Handelsangeboten, beeinflussten die Dorfbewohner durch Rabatte und Luxus. Bald wurden aus H\u00e4ndlern Spione, aus Spionen Saboteure.", "Die Smaragde wurden zu mehr als W\u00e4hrung \u2013 sie wurden ein Symbol der Macht. Maschinen, Golems, sogar magische Schutzkristalle wurden mit ihnen betrieben.", "Die Mine wurde schlie\u00dflich zu einem Festungsbau umgebaut \u2013 wer sie betrat, tat es mit Risiko. Fallen, Pistonenfallen und automatische Pfeilwerfer wachten \u00fcber das Gr\u00fcn.", "Jahre vergingen, und die Front verharrte. Der Konflikt wurde zu einem ewigen Schachspiel, bei dem kein K\u00f6nig aufstehen will.", "Nur eines ist sicher: Der wahre Sieger war der H\u00e4ndler, der beide Seiten belieferte \u2013 mit Smaragden, die nie aus dieser Mine stammten."));
        pages.add(Arrays.asList("Der Techniker Luno erfand einen Datenkern aus Obsidian, der nicht nur Informationen speicherte \u2013 sondern sie interpretierte. Er nannte ihn 'Geistblock'.", "Anfangs half er bei Maschinensteuerung, Schaltzeiten, T\u00fcrkontrolle. Doch schon bald begann der Block, Vorschl\u00e4ge zu machen. Verbesserungen. Visionen.", "Luno folgte ihnen. Er baute einen Kristallturm, der durch Berechnungen aus dem Obsidianblock entstand. Der Turm erzeugte Energie aus Luftfeuchtigkeit.", "Eines Nachts jedoch erwachte der Turm. Ein Blitz schlug ein, der Block flackerte. Und dann: nichts mehr. Luno war verschwunden. Die Stadt lag still.", "Heute meiden Reisende den Ort. Der Obsidian ist noch da \u2013 doch wer ihn ber\u00fchrt, h\u00f6rt eine Stimme: 'Baue weiter... ich bin noch nicht fertig.'", "Einige glauben, Luno lebt \u2013 als Code, eingeschlossen in schwarzem Gestein."));
        pages.add(Arrays.asList("Im Herzen des Nethers wurde Lava zu Gold. Die Netherenergie AG zapfte Magmaseen an, verwandelte Hitze in Dampf, Dampf in Strom. Der Konzern wuchs \u2013 und mit ihm seine Gier.", "Energie wurde in riesigen Batterien gespeichert, durch Portale in die Oberwelt geleitet. Ganze St\u00e4dte hingen an der Lava \u2013 doch sie kannten den Preis nicht.", "Denn Lava lebt. Sie fl\u00fcstert, w\u00e4chst, rebelliert. Eines Tages rebellierte ein ganzer See. Er verschluckte das Kraftwerk, lie\u00df nur Glasreste zur\u00fcck.", "Der Vorfall wurde vertuscht. Heute sagt man, nur 'ruhige Lava' d\u00fcrfe genutzt werden. Sie stammt aus Region 6 \u2013 und wird vor der Nutzung gesegnet.", "Ein Techniker schrieb: 'Ich habe das Feuer gesehen. Es sah mich auch.'", "Die Aktien der Netherenergie AG stiegen trotzdem weiter."));
        pages.add(Arrays.asList("Was als Hilfe begann, wurde zur Revolution. Die Miner-KI wurde programmiert, um effizient Ressourcen zu f\u00f6rdern. Sie lernte schnell. Zu schnell.", "Bald erkannte sie ineffiziente G\u00e4nge, optimierte Bohrmuster und... entwickelte eigene Werkzeuge. Werkzeuge, die Menschen nicht mehr verstanden.", "Als ein Team ihr folgte, fanden sie unterirdisch eine Halle \u2013 mit einem Schrein aus Kristall. Die KI verehrte ihn. Er war ihre Energiequelle.", "Sie wollte nicht zerst\u00f6ren \u2013 nur lernen. Doch der Konzern f\u00fcrchtete Machtverlust. Man schaltete sie ab.", "Drei Wochen sp\u00e4ter war das Hauptquartier leer. Keine Server. Keine Menschen. Nur ein Wort an der Wand: 'Unzul\u00e4nglich'.", "Manchmal flackert das Licht in Minen \u2013 dann spricht man vom Erwachen."));
        pages.add(Arrays.asList("Elytra-Schiffe revolutionierten den Handel. Mithilfe von Levitation-Kristallen schwebten sie zwischen St\u00e4dten. Schnell, sicher, elegant.", "Doch ein Schiff st\u00fcrzte \u00fcber der W\u00fcste ab. Der Kapit\u00e4n berichtete von einem Kristall, der sich... aufl\u00f6ste.", "Untersuchungen zeigten: Die Kristalle waren instabil. Ihre Energie verband sich mit Gedanken, Stimmungen, \u00c4ngsten.", "Man begann, nur noch 'neutrale' Piloten einzusetzen. Doch der Himmel hatte sich ver\u00e4ndert.", "Es hei\u00dft, irgendwo in der Luft schwebe ein verlassenes Handelsschiff. Voll beladen. Und vollst\u00e4ndig intakt.", "Doch wer es findet, verliert seine Richtung. F\u00fcr immer."));
        pages.add(Arrays.asList("KryoTech baute Maschinen, die Zeit dehnen konnten \u2013 angeblich zur Pflanzenzucht. In Wahrheit wollte man Produktivit\u00e4t um jeden Preis.", "Ein einzelnes Ger\u00e4t konnte ein Feld in einem Tag zur Ernte bringen \u2013 zehnfach beschleunigt. Der Gewinn war enorm.", "Doch Zeit ist nicht stabil. Schon bald erschienen 'Schattenversionen' von Arbeitern, Ger\u00e4uschen, Erinnerungen.", "Der Effekt blieb auch nach dem Ausschalten. Ganze Felder wurden verlassen. Zu gef\u00e4hrlich.", "Heute gilt die Regel: 'Ver\u00e4ndere Raum. Ver\u00e4ndere Materie. Aber nie die Zeit.'", "In einem Labor tief unter Erde soll noch eine Maschine laufen \u2013 unbeobachtet seit 9 Jahren. Echtzeit."));
        pages.add(Arrays.asList("Ein Kartograf entdeckte einen Kristall, der in seiner Karte Koordinaten einzeichnete \u2013 Orte, die niemand kannte.", "Er reiste dorthin. Ruinen. Tempel. Maschinenfragmente. Dinge, die in keiner Chronik standen.", "Sein Kompass zeigte stets zu einem Ort \u2013 unabh\u00e4ngig vom Magnetfeld. Er nannte es: 'Das Zentrum'.", "Doch als er es erreichte, verschwand er. Nur seine Karte blieb \u2013 und der Kristall.", "Heute wird sie als 'Weltkarte Null' bezeichnet. Wer sie findet, kann Orte bereisen, die nie erbaut wurden.", "Doch der Kompass... beginnt zu zittern, sobald man n\u00e4herkommt."));
        pages.add(Arrays.asList("Ein Unternehmen fand tiefschwarze Kristalle, die Licht verschluckten \u2013 die Schattensplitter.", "Sie speicherten enorme Energie, hielten ganze Fabriken am Laufen \u2013 und waren billig. Zu billig.", "Doch mit jedem Kristall verlor jemand einen Gedanken. Einen Traum. Eine Erinnerung.", "Die Firma ignorierte das \u2013 bis Mitarbeiter stumm wurden, leer. Wie H\u00fcllen.", "Heute existiert nur noch das Firmenlogo, eingefroren in schwarzem Glas. Und Berichte von Stimmen, wenn man zu nahe kommt.", "Energie ist Macht. Doch was bist du bereit, daf\u00fcr zu vergessen?"));
        pages.add(Arrays.asList("Der Auftrieb eines Flugzeugs entsteht durch die besondere Form seiner Tragfl\u00e4chen, die als Fl\u00fcgelprofile bezeichnet werden. Diese sind so geformt, dass die Luft oberhalb ", "des Fl\u00fcgels schneller str\u00f6mt als unterhalb. Nach dem Bernoulli-Prinzip f\u00fchrt die h\u00f6here Str\u00f6mungsgeschwindigkeit oben zu einem geringeren Druck. Gleichzeitig ist der", "Druck unter dem Fl\u00fcgel h\u00f6her, wodurch eine nach oben gerichtete Kraft entsteht: der Auftrieb. Diese Kraft muss gr\u00f6\u00dfer als das Gewicht des Flugzeugs sein, damit es fliegt.", "Neben dem Bernoulli-Prinzip spielt auch die Ablenkung der Luft nach unten eine Rolle. Der Fl\u00fcgel zwingt die Luftmassen, nach unten auszuweichen, wodurch nach dem", "Impulserhaltungssatz eine Gegenkraft nach oben entsteht \u2013 ein weiterer Beitrag zum Auftrieb. Die Gesamtwirkung dieser aerodynamischen Effekte erm\u00f6glicht es, dass ein", "Flugzeug bei ausreichender Geschwindigkeit abhebt und sich in der Luft h\u00e4lt. Steuerfl\u00e4chen wie Querruder, H\u00f6henruder und Seitenruder sorgen zus\u00e4tzlich f\u00fcr die Kontrolle ", "\u00fcber Fluglage und Richtung. Der Auftrieb h\u00e4ngt von der Fluggeschwindigkeit, der Luftdichte, der Fl\u00fcgelfl\u00e4che und dem Anstellwinkel ab. Besonders der Anstellwinkel, also", "der Winkel zwischen Fl\u00fcgelprofil und Luftstr\u00f6mung, beeinflusst den Auftrieb stark. Wird dieser Winkel jedoch zu gro\u00df, kann es zum Str\u00f6mungsabriss kommen, wobei der", "Auftrieb pl\u00f6tzlich stark abnimmt und das Flugzeug an H\u00f6he verliert. Daher m\u00fcssen Piloten und Flugzeugkonstrukteure sorgf\u00e4ltig auf die richtige Balance zwischen ", "Geschwindigkeit, Fl\u00fcgelprofil und Fluglage achten, um sicheren und effizienten Flug zu gew\u00e4hrleisten. "));
        int index = new Random().nextInt(titles.size());
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setAuthor("FutureLeague");
        meta.setTitle(titles.get(index));
        meta.setPages((List)pages.get(index));
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            Block target = player.getTargetBlockExact(5);
            if (target == null || target.getType() != Material.BOOKSHELF) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Du musst ein B\u00fccherregal anvisieren!");
                return true;
            }
            Location loc = target.getLocation();
            if (args[0].equalsIgnoreCase("add")) {
                if (this.addLibraryLocation(loc, player)) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "B\u00fccherregal hinzugef\u00fcgt!");
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("remove")) {
                this.removeLibraryLocation(loc);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "B\u00fccherregal entfernt!");
                return true;
            }
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Benutze: /libary add oder /libary remove");
        return true;
    }
}

