/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Studium;

import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigManager;
import de.flipper1406.futureleague_wirtschaft.FutureLeague_Wirtschaft;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PruefungsGUI
implements Listener,
CommandExecutor {
    private final FutureLeague_Wirtschaft plugin;
    private final ConfigManager configManager;
    private final Map<UUID, ExamSession> sessions = new HashMap<UUID, ExamSession>();

    public PruefungsGUI(FutureLeague_Wirtschaft plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            return true;
        }
        String commandName = cmd.getName().toLowerCase();
        if (!commandName.equalsIgnoreCase("pruefung")) {
            return true;
        }
        if (args.length == 2) {
            String playerName = args[1];
            String studiengang = args[0];
            Player player = Bukkit.getPlayer((String)playerName);
            if (!this.configManager.getValue(playerName, "studiengang_" + studiengang + "_aktiv", true)) {
                Bukkit.getPlayer((String)playerName).sendMessage("\u00a76Pr\u00fcfer \u00a7c>>\u00a7e Du bist derzeit nicht im Studiengang\u00a76 " + studiengang + "\u00a7e eingetragen!");
                return true;
            }
            boolean studiengangCompleted = false;
            if (studiengang.equalsIgnoreCase("luftundraumfahrt")) {
                if (this.configManager.getValue(playerName, "vorlesungAbgeschlossen_sonnensystem", true) && this.configManager.getValue(playerName, "vorlesungAbgeschlossen_luftfahrt", true) && this.configManager.getValue(playerName, "vorlesungAbgeschlossen_raketenaufbau", true)) {
                    studiengangCompleted = true;
                }
            } else if (studiengang.equalsIgnoreCase("geologie")) {
                if (this.configManager.getValue(playerName, "vorlesungAbgeschlossen_goldsuche", true) && this.configManager.getValue(playerName, "vorlesungAbgeschlossen_edelsteine", true) && this.configManager.getValue(playerName, "vorlesungAbgeschlossen_kristalle", true)) {
                    studiengangCompleted = true;
                }
            } else if (studiengang.equalsIgnoreCase("landwirtschaft") && this.configManager.getValue(playerName, "vorlesungAbgeschlossen_dreifelderwirtschaft", true) && this.configManager.getValue(playerName, "vorlesungAbgeschlossen_pflanzunderntezeiten", true) && this.configManager.getValue(playerName, "vorlesungAbgeschlossen_biosiegel", true)) {
                studiengangCompleted = true;
            }
            if (!studiengangCompleted) {
                Bukkit.getPlayer((String)playerName).sendMessage("\u00a76Pr\u00fcfer \u00a7c>>\u00a7e Du hast noch nicht alle Module abgeschlossen. Komme wieder, wenn du alle abgeschlossen hast.");
                Bukkit.getPlayer((String)playerName).sendMessage("\u00a76Pr\u00fcfer \u00a7c>>\u00a7e Beim Empfang kannst du nachfragen, welche Module dir noch fehlen, sofern du dies nicht sicher wei\u00dft!");
                return true;
            }
            this.startePruefung(player, studiengang);
        }
        return true;
    }

    public void startePruefung(Player player, String studiengang) {
        ArrayList<Question> questions = new ArrayList<Question>();
        switch (studiengang) {
            case "luftundraumfahrt": {
                questions.add(new Question("Wie schnell fliegen moderne Raketen in etwa?", new String[]{"\u00fcber 28.000 km/h", "ca. 20.000 km/h", "\u00fcber 45.000 km/h"}, 0));
                questions.add(new Question("Wie lang dauerte der erste Motorflug von den Br\u00fcdern Wright im Jahr 1903?", new String[]{"1 Minute", "3 Minuten", "12 Sekunden"}, 2));
                questions.add(new Question("Wie schnell reisen Passagierflugzeuge heutzutage?", new String[]{"9.000 km/h", "900 km/h", "1900 km/h"}, 1));
                questions.add(new Question("Wie viele Monde hat der Saturn?", new String[]{"145", "74", "89"}, 0));
                break;
            }
            case "geologie": {
                questions.add(new Question("Auf welchen Edelstein trifft diese Definition zu: Ein violetter Stein, der f\u00fcr Ruhe und Klarheit steht.", new String[]{"Saphir", "Rubin", "Amethyst"}, 2));
                questions.add(new Question("Auf welchen Edelstein trifft diese Definition zu: Oft blau, aber es gibt ihn auch in anderen Farben. Er steht f\u00fcr Weisheit und Wahrheit.", new String[]{"Diamant", "Saphir", "Amethyst"}, 1));
                questions.add(new Question("Der Fortschritt des Kristalls: Was fanden die Forscher bei den Kristallen heraus?", new String[]{"Kristalle k\u00f6nnen Energie speichern und abgeben", "geschliffen sind sie sehr wertvoll", "Kristalle k\u00f6nnen wenn sie richtig verarbeitet werden h\u00e4rter als Diamanten sein."}, 0));
                questions.add(new Question("In welche L\u00e4nder reisten viele Menschen zu Zeiten des Goldrausches um reich zu werden?", new String[]{"USA und Kanada", "USA und Australien", "USA und Mexiko"}, 1));
                questions.add(new Question("Wird in Deutschland Gold aktiv gef\u00f6rdert?", new String[]{"Nein, seit 1990 nicht mehr.", "ja, seit 1990 wieder.", "ja, seit 1980 wieder"}, 0));
                break;
            }
            case "landwirtschaft": {
                questions.add(new Question("Was z\u00e4hlt zum Wintergetreide?", new String[]{"Weizen & Roggen", "Mais und Gerste", "Roggen und Hafer"}, 0));
                questions.add(new Question("Wann sollte man Kartoffeln und Mais pflanzen?", new String[]{"Sommer", "Winter", "Fr\u00fchling"}, 2));
                questions.add(new Question("Wann werden \u00c4pfel & Kirschen idealerweise gepfl\u00fcckt?", new String[]{"Sommer", "Herbst", "Winter"}, 1));
                questions.add(new Question("Eine der folgenden Aussagen ist falsch. Welche?", new String[]{"Auch die Tiere, die f\u00fcr Bio-Fleisch oder -Milch sorgen, leben in besseren Bedingungen, mit mehr Platz und nat\u00fcrlicherer Ern\u00e4hrung.", "Das Bio-G\u00fctesiegel zeigt, dass ein Produkt auf eine besonders natu\u0308rliche Weise hergestellt wurde.", "Der Landwirt darf scha\u0308dliche Chemikalien oder Spritzmittel verwenden und diese Produkte trotzdem mit einem Bio-Siegel verkaufen."}, 2));
            }
        }
        if (questions.isEmpty()) {
            player.sendMessage("Keine Fragen definiert.");
            return;
        }
        ExamSession session = new ExamSession(player, questions, studiengang);
        this.sessions.put(player.getUniqueId(), session);
        session.openNextQuestion();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ExamSession session = this.sessions.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        if (event.getInventory().equals((Object)session.getInventory())) {
            event.setCancelled(true);
            int slot = event.getRawSlot();
            if (slot == 11 || slot == 13 || slot == 15) {
                int answerIndex = slot == 11 ? 0 : (slot == 13 ? 1 : 2);
                session.handleAnswer(answerIndex);
                if (session.isFinished()) {
                    this.sessions.remove(player.getUniqueId());
                }
            }
        }
    }

    private void pruefungbestanden(Player player, double percentage, String studiengang) {
        this.configManager.setValue(player.getName(), "studiumAbgeschlossen_" + studiengang, true);
        this.configManager.setValue(player.getName(), "studiengang_" + studiengang + "_aktiv" + studiengang, false);
        this.addGroup(player, "absolvent_" + studiengang);
        this.insertTimestamp(player, studiengang, true);
        player.sendMessage("\u00a76Pr\u00fcfer \u00a7c>>\u00a7e In dieser Pr\u00fcfung hast du " + percentage + "% erreicht. Damit ist die Pr\u00fcfung bestanden!");
    }

    private void pruefungNichtBestanden(Player player, double percentage, String studiengang) {
        player.sendMessage("\u00a76Pr\u00fcfer \u00a7c>>\u00a7e Du hast die Pr\u00fcfung leider nicht bestanden! Bitte wiederhole deine Vorlesungen und komme im Anschluss wieder zu mir, wenn du bereit bist!");
        player.sendMessage("\u00a76Pr\u00fcfer \u00a7c>>\u00a7e In dieser Pr\u00fcfung hast du " + percentage + "% erreicht. Zum Bestehen brauchst du mindestens 70%");
        if (studiengang.equalsIgnoreCase("geologie")) {
            this.configManager.setValue(player.getName(), "vorlesungAbgeschlossen_edelsteine", false);
            this.configManager.setValue(player.getName(), "vorlesungAbgeschlossen_kristalle", false);
            this.configManager.setValue(player.getName(), "vorlesungAbgeschlossen_goldsuche", false);
        } else if (studiengang.equalsIgnoreCase("landwirtschaft")) {
            this.configManager.setValue(player.getName(), "vorlesungAbgeschlossen_dreifelderwirtschaft", false);
            this.configManager.setValue(player.getName(), "vorlesungAbgeschlossen_biosiegel", false);
            this.configManager.setValue(player.getName(), "vorlesungAbgeschlossen_pflanzunderntezeiten", false);
        } else if (studiengang.equalsIgnoreCase("luftundraumfahrt")) {
            this.configManager.setValue(player.getName(), "vorlesungAbgeschlossen_raketenaufbau", false);
            this.configManager.setValue(player.getName(), "vorlesungAbgeschlossen_luftfahrt", false);
            this.configManager.setValue(player.getName(), "vorlesungAbgeschlossen_sonnensystem", false);
        }
    }

    public void insertTimestamp(Player player, String module, boolean studium) {
        String playerName = player.getName();
        Date currentTime = new Date();
        if (studium) {
            this.configManager.setValue(playerName, "studiumAbgeschlossen_timestamp_" + module, currentTime);
        } else {
            this.configManager.setValue(playerName, "letzteVorlesung", module);
            this.configManager.setValue(playerName, "vorlesungAbgeschlossen_timestamp_" + module, currentTime);
        }
    }

    public void addGroup(Player player, String studiengang) {
        ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
        String command = "lp user " + player.getName() + " group add " + studiengang;
        Bukkit.dispatchCommand((CommandSender)console, (String)command);
    }

    private class Question {
        private final String questionText;
        private final String[] options;
        private final int correctIndex;

        public Question(String questionText, String[] options, int correctIndex) {
            this.questionText = questionText;
            this.options = options;
            this.correctIndex = correctIndex;
        }

        public String getQuestionText() {
            return this.questionText;
        }

        public String[] getOptions() {
            return this.options;
        }

        public int getCorrectIndex() {
            return this.correctIndex;
        }
    }

    private class ExamSession {
        private final Player player;
        private final List<Question> questions;
        private int currentIndex = 0;
        private int correctCount = 0;
        private final Inventory inventory;
        private final String studiengang;

        public ExamSession(Player player, List<Question> questions, String studiengang) {
            this.player = player;
            this.questions = questions;
            this.studiengang = studiengang;
            this.inventory = Bukkit.createInventory(null, (int)27, (String)"Pr\u00fcfung");
        }

        public Inventory getInventory() {
            return this.inventory;
        }

        public void openNextQuestion() {
            if (this.currentIndex >= this.questions.size()) {
                this.finishExam();
                return;
            }
            Question currentQuestion = this.questions.get(this.currentIndex);
            this.inventory.clear();
            ItemStack questionItem = new ItemStack(Material.PAPER);
            ItemMeta qm = questionItem.getItemMeta();
            qm.setDisplayName(currentQuestion.getQuestionText());
            questionItem.setItemMeta(qm);
            this.inventory.setItem(4, questionItem);
            String[] options = currentQuestion.getOptions();
            int[] slots = new int[]{11, 13, 15};
            for (int i = 0; i < options.length; ++i) {
                ItemStack answerItem = new ItemStack(Material.LIME_STAINED_GLASS_PANE, 1, 14);
                ItemMeta am = answerItem.getItemMeta();
                am.setDisplayName(options[i]);
                answerItem.setItemMeta(am);
                this.inventory.setItem(slots[i], answerItem);
            }
            this.player.openInventory(this.inventory);
        }

        public void handleAnswer(int chosenIndex) {
            Question currentQuestion = this.questions.get(this.currentIndex);
            if (currentQuestion.getCorrectIndex() == chosenIndex) {
                ++this.correctCount;
            }
            ++this.currentIndex;
            this.openNextQuestion();
        }

        public boolean isFinished() {
            return this.currentIndex >= this.questions.size();
        }

        private void finishExam() {
            this.player.closeInventory();
            double percentage = (double)this.correctCount / (double)this.questions.size() * 100.0;
            if (percentage >= 70.0) {
                PruefungsGUI.this.pruefungbestanden(this.player, percentage, this.studiengang);
            } else {
                PruefungsGUI.this.pruefungNichtBestanden(this.player, percentage, this.studiengang);
            }
        }
    }
}

