/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.ConfigManager;

import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileExp;
import de.flipper1406.futureleague_wirtschaft.FutureLeague_Wirtschaft;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ConfigManager {
    private final File file;
    private final FileConfiguration config;

    public ConfigManager(FutureLeague_Wirtschaft plugin) {
        ConfigFileExp configFileExp = plugin.getConfigFileExp();
        this.file = new File(plugin.getDataFolder(), "playerdata.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.load();
    }

    public void load() {
        if (!this.file.exists()) {
            this.config.options().copyDefaults(true);
            this.config.addDefault("player.futureLeague.dummy", (Object)1);
            this.save();
        } else {
            try {
                this.config.load(this.file);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getOnMission(Player p) {
        return this.config.getBoolean("player." + p.getName() + ".onMission");
    }

    public void setOnMission(Player p, boolean value) {
        this.config.set("player." + p.getName() + ".onMission", (Object)value);
    }

    public void setRewards(Player p, String jobName, boolean value) {
        String job = "job_" + jobName + "_Belohnung";
        this.config.set("player." + p.getName() + "." + job, (Object)value);
    }

    public boolean getRewards(Player p, String jobName) {
        String job = "job_" + jobName + "_Belohnung";
        return this.config.getBoolean("player." + p.getName() + "." + job);
    }

    public void addNewPlayer(String username) {
        String currentTime = new SimpleDateFormat("dd.MM.yyyy").format(new Date()) + " um " + new SimpleDateFormat("HH:mm:ss").format(new Date());
        Location lastLocation = new Location(Bukkit.getWorld((String)"city"), 0.0, 60.0, 0.0);
        this.config.set("player." + username + ".hasJob", (Object)false);
        this.config.set("player." + username + ".currentJob", (Object)"Arbeitslos");
        this.config.set("player." + username + ".job_F\u00f6rster_Level", (Object)0);
        this.config.set("player." + username + ".job_F\u00f6rster_EXP", (Object)0);
        this.config.set("player." + username + ".job_F\u00f6rster_Belohnung", (Object)false);
        this.config.set("player." + username + ".job_Feuerwehr_Level", (Object)0);
        this.config.set("player." + username + ".job_Feuerwehr_EXP", (Object)0);
        this.config.set("player." + username + ".job_Feuerwehr_Belohnung", (Object)false);
        this.config.set("player." + username + ".job_Angler_Level", (Object)0);
        this.config.set("player." + username + ".job_Angler_EXP", (Object)0);
        this.config.set("player." + username + ".job_Angler_Belohnung", (Object)false);
        this.config.set("player." + username + ".job_Putzdienst_Level", (Object)0);
        this.config.set("player." + username + ".job_Putzdienst_EXP", (Object)0);
        this.config.set("player." + username + ".job_Putzdienst_Belohnung", (Object)false);
        this.config.set("player." + username + ".job_K\u00e4mpfer_Level", (Object)0);
        this.config.set("player." + username + ".job_K\u00e4mpfer_EXP", (Object)0);
        this.config.set("player." + username + ".job_K\u00e4mpfer_Belohnung", (Object)false);
        this.config.set("player." + username + ".job_Minenarbeiter_Level", (Object)0);
        this.config.set("player." + username + ".job_Minenarbeiter_EXP", (Object)0);
        this.config.set("player." + username + ".job_Minenarbeiter_Belohnung", (Object)false);
        this.config.set("player." + username + ".job_Landwirt_Level", (Object)0);
        this.config.set("player." + username + ".job_Landwirt_EXP", (Object)0);
        this.config.set("player." + username + ".job_Landwirt_Belohnung", (Object)false);
        this.config.set("player." + username + ".job_Florist_Level", (Object)0);
        this.config.set("player." + username + ".job_Florist_EXP", (Object)0);
        this.config.set("player." + username + ".job_Florist_Belohnung", (Object)false);
        this.config.set("player." + username + ".job_Rettungsdienst_Level", (Object)0);
        this.config.set("player." + username + ".job_Rettungsdienst_EXP", (Object)0);
        this.config.set("player." + username + ".job_Rettungsdienst_Belohnung", (Object)false);
        this.config.set("player." + username + ".job_Gastronom_Level", (Object)0);
        this.config.set("player." + username + ".job_Gastronom_EXP", (Object)0);
        this.config.set("player." + username + ".job_Gastronom_Belohnung", (Object)false);
        this.config.set("player." + username + ".onMission", (Object)false);
        this.config.set("player." + username + ".firstJoin", (Object)currentTime);
        this.config.set("player." + username + ".lastOnline", (Object)currentTime);
        this.config.set("player." + username + ".daysLoggedIn", (Object)0);
        this.config.set("player." + username + ".gamemode", (Object)"\u00dcberlebensmodus");
        this.config.set("player." + username + ".moderatorModus", (Object)false);
        this.config.set("player." + username + ".lastLocation", (Object)lastLocation);
        this.config.set("player." + username + ".dekofigur", (Object)false);
        this.config.set("player." + username + ".vorlesungAktiv", (Object)false);
        this.config.set("player." + username + ".vorlesungAbgeschlossen_raketenaufbau", (Object)false);
        this.config.set("player." + username + ".vorlesungAbgeschlossen_luftfahrt", (Object)false);
        this.config.set("player." + username + ".vorlesungAbgeschlossen_sonnensystem", (Object)false);
        this.config.set("player." + username + ".vorlesungAbgeschlossen_dreifelderwirtschaft", (Object)false);
        this.config.set("player." + username + ".vorlesungAbgeschlossen_pflanzunderntezeiten", (Object)false);
        this.config.set("player." + username + ".vorlesungAbgeschlossen_viehzucht", (Object)false);
        this.config.set("player." + username + ".vorlesungAbgeschlossen_edelsteine", (Object)false);
        this.config.set("player." + username + ".vorlesungAbgeschlossen_kristalle", (Object)false);
        this.config.set("player." + username + ".vorlesungAbgeschlossen_goldsuche", (Object)false);
        this.config.set("player." + username + ".studiumAbgeschlossen_luftundraumfahrt", (Object)false);
        this.config.set("player." + username + ".studiumAbgeschlossen_geologie", (Object)false);
        this.config.set("player." + username + ".studiumAbgeschlossen_landwirtschaft", (Object)false);
        this.config.set("player." + username + ".studiengang_geologie_aktiv", (Object)false);
        this.config.set("player." + username + ".studiengang_luftundraumfahrt_aktiv", (Object)false);
        this.config.set("player." + username + ".studiengang_landwirtschaft_aktiv", (Object)false);
        this.config.set("player." + username + ".studiumAbgeschlossen_timestamp_luftundraumfahrt", (Object)"0");
        this.config.set("player." + username + ".studiumAbgeschlossen_timestamp_geologie", (Object)"0");
        this.config.set("player." + username + ".studiumAbgeschlossen_timestamp_landwirtschaft", (Object)"0");
        this.config.set("player." + username + ".vorlesungAbgeschlossen_timestamp_raketenaufbau", (Object)"0");
        this.config.set("player." + username + ".vorlesungAbgeschlossen_timestamp_luftfahrt", (Object)"0");
        this.config.set("player." + username + ".vorlesungAbgeschlossen_timestamp_sonnensystem", (Object)"0");
        this.config.set("player." + username + ".vorlesungAbgeschlossen_timestamp_kristalle", (Object)"0");
        this.config.set("player." + username + ".vorlesungAbgeschlossen_timestamp_edelsteine", (Object)"0");
        this.config.set("player." + username + ".vorlesungAbgeschlossen_timestamp_goldsuche", (Object)"0");
        this.config.set("player." + username + ".vorlesungAbgeschlossen_timestamp_pflanzunderntezeiten", (Object)"0");
        this.config.set("player." + username + ".vorlesungAbgeschlossen_timestamp_viehzucht", (Object)"0");
        this.config.set("player." + username + ".vorlesungAbgeschlossen_timestamp_dreifelderwirtschaft", (Object)"0");
        this.config.set("player." + username + ".letzteVorlesung", (Object)"-");
        this.save();
    }

    private void add(String username, String action, boolean value) {
        this.config.set("player." + username + "." + action, (Object)value);
        this.save();
    }

    private void add(String username, String action, String value) {
        this.config.set("player." + username + "." + action, (Object)value);
        this.save();
    }

    private void add(String username, String action, Location value) {
        this.config.set("player." + username + "." + action, (Object)value);
        this.save();
    }

    private void add(String username, String action, int value) {
        this.config.set("player." + username + "." + action, (Object)value);
        this.save();
    }

    private void edit(String username, String action, boolean value) {
        this.config.set("player." + username + "." + action, (Object)value);
        this.save();
    }

    private void edit(String username, String action, String value) {
        this.config.set("player." + username + "." + action, (Object)value);
        this.save();
    }

    private void edit(String username, String action, Location value) {
        this.config.set("player." + username + "." + action, (Object)value);
        this.save();
    }

    private void edit(String username, String action, int value) {
        this.config.set("player." + username + "." + action, (Object)value);
        this.save();
    }

    public void setValue(String username, String action, boolean value) {
        if (!this.checkForPlayerInConfig(username)) {
            this.add(username, action, value);
        } else {
            this.edit(username, action, value);
        }
    }

    public void setValue(String username, String action, Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String value = format.format(date);
        if (!this.checkForPlayerInConfig(username)) {
            this.add(username, action, value);
        } else {
            this.edit(username, action, value);
        }
    }

    public void setValue(String username, String action, String value) {
        if (!this.checkForPlayerInConfig(username)) {
            this.add(username, action, value);
        } else {
            this.edit(username, action, value);
        }
    }

    public void setValue(String username, String action, Location value) {
        if (!this.checkForPlayerInConfig(username)) {
            this.add(username, action, value);
        } else {
            this.edit(username, action, value);
        }
    }

    public void setValue(String username, String action, int value) {
        if (!this.checkForPlayerInConfig(username)) {
            this.add(username, action, value);
        } else {
            this.edit(username, action, value);
        }
    }

    public String getValue(String username, String action) {
        if (this.checkForPlayerInConfig(username)) {
            return this.config.getString("player." + username + "." + action);
        }
        return "";
    }

    public int getValue(String username, String action, int i) {
        if (this.checkForPlayerInConfig(username)) {
            return this.config.getInt("player." + username + "." + action);
        }
        return 0;
    }

    public boolean getValue(String username, String action, boolean bool) {
        if (this.checkForPlayerInConfig(username)) {
            return this.config.getBoolean("player." + username + "." + action);
        }
        return false;
    }

    public Location getValue(String username, String action, Location loc) {
        if (this.checkForPlayerInConfig(username)) {
            return this.config.getLocation("player." + username + "." + action);
        }
        return loc;
    }

    public boolean checkForPlayerInConfig(String checkUser) {
        for (int i = 0; i < this.getPlayers().size(); ++i) {
            if (!this.getPlayers().get(i).equals(checkUser)) continue;
            return true;
        }
        return false;
    }

    public List<String> getPlayers() {
        Set children = this.config.getConfigurationSection("player").getKeys(false);
        return new ArrayList<String>(children);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

