/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Userdata.Commands;

import de.flipper1406.futureleague_wirtschaft.Userdata.Utils.UserDataManager;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MoneyCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player) && args.length < 1) {
            sender.sendMessage("\u00a7cBitte gib einen Spielernamen oder Befehl an.");
            return true;
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        boolean isAdmin = sender.hasPermission("futureleague.money.admin");
        if (args.length == 1) {
            String targetName = args[0];
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
            UUID uuid = target.getUniqueId();
            if (!(isAdmin || player != null && player.getUniqueId().equals(uuid))) {
                sender.sendMessage("\u00a7cDu darfst nur deinen eigenen Kontostand sehen.");
                uuid = player.getUniqueId();
                target = player;
            }
            double balance = UserDataManager.getBalance(uuid);
            sender.sendMessage("\u00a7eKontostand von \u00a76" + target.getName() + "\u00a7e: \u00a7a" + balance + " Euro");
            return true;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("set")) {
            double amount;
            if (!isAdmin) {
                sender.sendMessage("\u00a7cKeine Berechtigung.");
                return true;
            }
            String targetName = args[1];
            try {
                amount = Double.parseDouble(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cUng\u00fcltiger Betrag.");
                return true;
            }
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
            UUID uuid = target.getUniqueId();
            UserDataManager.setBalance(uuid, amount);
            UserDataManager.logTransaction(uuid, null, amount, "Anpassung vom System");
            sender.sendMessage("\u00a7aKontostand von " + target.getName() + " wurde auf \u00a7e" + amount + " Euro \u00a7agesetzt.");
            return true;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("add")) {
            double amount;
            if (!isAdmin) {
                sender.sendMessage("\u00a7cKeine Berechtigung.");
                return true;
            }
            String targetName = args[1];
            try {
                amount = Double.parseDouble(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cUng\u00fcltiger Betrag.");
                return true;
            }
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
            UUID uuid = target.getUniqueId();
            double newBalance = UserDataManager.getBalance(uuid) + amount;
            UserDataManager.setBalance(uuid, newBalance);
            UserDataManager.logTransaction(uuid, null, amount, "\u00dcberweisung vom System");
            sender.sendMessage("\u00a7a" + amount + " Euro wurden \u00a7e" + target.getName() + " \u00a7agutgeschrieben.");
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("top")) {
            int count;
            if (!isAdmin) {
                sender.sendMessage("\u00a7cKeine Berechtigung.");
                return true;
            }
            try {
                count = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cUng\u00fcltige Zahl.");
                return true;
            }
            Map<UUID, Double> allBalances = UserDataManager.getAllBalances();
            List sorted = allBalances.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(count).collect(Collectors.toList());
            sender.sendMessage("\u00a76\u00a7lTop " + count + " Kontost\u00e4nde:");
            int place = 1;
            for (Map.Entry entry : sorted) {
                OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey()));
                sender.sendMessage("\u00a7e" + place++ + ". \u00a7b" + p.getName() + "\u00a77: \u00a7a" + String.valueOf(entry.getValue()) + " Euro");
            }
            return true;
        }
        sender.sendMessage("\u00a7cUng\u00fcltiger Befehl.");
        return true;
    }
}

