/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools.Ampeln;

import de.flipper1406.futureleague_wirtschaft.FutureLeague_Wirtschaft;
import de.flipper1406.futureleague_wirtschaft.Tools.Ampeln.Ampel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class AmpelFileManager {
    private final File file;
    private final FileConfiguration config;
    private final String PathPrefix = "Ampeln";

    public AmpelFileManager(FutureLeague_Wirtschaft plugin) throws IOException, InvalidConfigurationException {
        this.file = new File(plugin.getDataFolder(), "AmpelLocations.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.load();
    }

    private void load() throws IOException, InvalidConfigurationException {
        if (!this.file.exists()) {
            this.config.options().copyDefaults(true);
            this.save();
        } else {
            this.config.load(this.file);
        }
    }

    private void save() throws IOException {
        this.config.save(this.file);
    }

    public List<Ampel> loadAmpeln() {
        ArrayList<Ampel> retVal = new ArrayList<Ampel>();
        ConfigurationSection section = this.config.getConfigurationSection("Ampeln");
        if (section == null) {
            return retVal;
        }
        for (String key : section.getKeys(false)) {
            Ampel ampel = (Ampel)section.get(key);
            if (ampel == null) continue;
            retVal.add(ampel);
        }
        return retVal;
    }

    public void saveAmpeln(List<Ampel> ampeln) throws IOException {
        this.config.set("Ampeln", null);
        for (int i = 0; i < ampeln.size(); ++i) {
            this.config.set("Ampeln." + i, (Object)ampeln.get(i));
        }
        this.save();
    }
}

