/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools.Elevator;

import de.flipper1406.futureleague_wirtschaft.Tools.Elevator.Elevator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ElevatorManager {
    private final JavaPlugin plugin;

    public ElevatorManager(JavaPlugin wirtschaftsPlugin) {
        this.plugin = wirtschaftsPlugin;
    }

    public void saveElevator(Elevator elevator) {
        FileConfiguration config = this.plugin.getConfig();
        String key = this.getKey(elevator.getButtonLocation());
        config.set("elevators." + key + ".name", (Object)elevator.getName());
        config.set("elevators." + key + ".owner", (Object)elevator.getOwner());
        config.set("elevators." + key + ".button", (Object)elevator.getButtonLocation());
        config.set("elevators." + key + ".teleport", (Object)elevator.getTeleportLocation());
        this.plugin.saveConfig();
    }

    public boolean elevatorExists(Location buttonLoc) {
        return this.plugin.getConfig().contains("elevators." + this.getKey(buttonLoc));
    }

    public boolean canRemove(Player player, Location buttonLoc) {
        String key = this.getKey(buttonLoc);
        if (!this.plugin.getConfig().contains("elevators." + key)) {
            return false;
        }
        String owner = this.plugin.getConfig().getString("elevators." + key + ".owner");
        return player.hasPermission("futureleague.aufzug.entfernen") || player.getName().equals(owner);
    }

    public void removeElevator(Location buttonLoc) {
        this.plugin.getConfig().set("elevators." + this.getKey(buttonLoc), null);
        this.plugin.saveConfig();
    }

    public List<Elevator> getElevatorsOnXZ(int x, int z, World world) {
        ArrayList<Elevator> list = new ArrayList<Elevator>();
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("elevators");
        if (section == null) {
            return list;
        }
        for (String key : section.getKeys(false)) {
            Location loc = this.plugin.getConfig().getLocation("elevators." + key + ".button");
            if (!loc.getWorld().equals((Object)world) || loc.getBlockX() != x || loc.getBlockZ() != z) continue;
            String name = this.plugin.getConfig().getString("elevators." + key + ".name");
            String owner = this.plugin.getConfig().getString("elevators." + key + ".owner");
            Location teleportLoc = this.plugin.getConfig().getLocation("elevators." + key + ".teleport");
            list.add(new Elevator(name, owner, loc, teleportLoc));
        }
        list.sort(Comparator.comparingInt(e -> e.getButtonLocation().getBlockY()));
        return list;
    }

    private String getKey(Location loc) {
        return loc.getWorld().getName() + "_" + loc.getBlockX() + "_" + loc.getBlockY() + "_" + loc.getBlockZ();
    }
}

