/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Utils;

import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldUtils {
    private final Plugin plugin;
    private static WorldUtils instance;

    public WorldUtils(Plugin plugin) {
        this.plugin = plugin;
    }

    public static void init(Plugin plugin) {
        if (instance == null) {
            instance = new WorldUtils(plugin);
        }
    }

    public static WorldUtils getInstance() {
        if (instance == null) {
            throw new IllegalStateException("WorldUtils not initialized! Call WorldUtils.init() first.");
        }
        return instance;
    }

    public void createWorld(String worldName, String environment) {
        String command = "mv create " + worldName + " " + environment;
        boolean success = Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        if (success) {
            Bukkit.getLogger().info("Befehl ausgef\u00fchrt: " + command);
        } else {
            Bukkit.getLogger().severe("Fehler beim Ausf\u00fchren des Befehls: " + command);
        }
    }

    public void deleteWorld(String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        if (world != null) {
            for (Player player : world.getPlayers()) {
                player.teleport(this.getCitySpawnLocation());
            }
            Bukkit.unloadWorld((World)world, (boolean)false);
        }
        File worldFolder = new File(Bukkit.getWorldContainer(), worldName);
        this.deleteDirectory(worldFolder);
        Bukkit.getLogger().info("Welt '" + worldName + "' wurde gel\u00f6scht (ohne Best\u00e4tigung).");
    }

    private boolean deleteDirectory(File path) {
        if (path == null || !path.exists()) {
            return true;
        }
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!(file.isDirectory() ? !this.deleteDirectory(file) : !file.delete())) continue;
                return false;
            }
        }
        return path.delete();
    }

    private Location getCitySpawnLocation() {
        return new Location(Bukkit.getWorld((String)"city"), 409.0, 113.0, -858.0);
    }

    public boolean worldExists(String worldName) {
        return Bukkit.getWorld((String)worldName) != null || new File(Bukkit.getWorldContainer(), worldName).exists();
    }
}

