/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Regions;

import de.flipper1406.futureleague_wirtschaft.Regions.BlockStateData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;

public final class Region {
    private static final double STANDARD_PRICE = 1000.0;
    private final String name;
    private UUID owner;
    private final Location min;
    private final Location max;
    private double price;
    private boolean isRentable;
    private boolean active = true;
    private final Set<UUID> builders = new HashSet<UUID>();
    private Map<String, Boolean> interactionPermissions = new HashMap<String, Boolean>();
    private boolean isFree;
    private boolean buyable = true;
    private final List<UUID> staff = new ArrayList<UUID>();
    private List<BlockStateData> savedBlocks = new ArrayList<BlockStateData>();
    private double userPrice;
    private boolean userOffer;
    private final List<Location> signs = new ArrayList<Location>();
    private String coOwner;
    private boolean playerWasActive;
    private int speedLevel = 0;

    private Region(Builder builder) {
        this.name = builder.name;
        this.owner = builder.owner;
        this.coOwner = builder.coOwner;
        this.min = this.getMin(builder.pos1, builder.pos2);
        this.max = this.getMax(builder.pos1, builder.pos2);
        this.price = builder.price;
        this.isRentable = builder.rentable;
        this.playerWasActive = builder.playerWasActive;
        this.speedLevel = builder.speedLevel;
        if (this.interactionPermissions.isEmpty()) {
            this.interactionPermissions.put("truhen", false);
            this.interactionPermissions.put("redstone_truhen", false);
            this.interactionPermissions.put("tueren", false);
            this.interactionPermissions.put("knoepfe", false);
            this.interactionPermissions.put("druckplatten", false);
        }
    }

    private Location getMin(Location a, Location b) {
        return new Location(a.getWorld(), (double)Math.min(a.getBlockX(), b.getBlockX()), (double)Math.min(a.getBlockY(), b.getBlockY()), (double)Math.min(a.getBlockZ(), b.getBlockZ()));
    }

    private Location getMax(Location a, Location b) {
        return new Location(a.getWorld(), (double)Math.max(a.getBlockX(), b.getBlockX()), (double)Math.max(a.getBlockY(), b.getBlockY()), (double)Math.max(a.getBlockZ(), b.getBlockZ()));
    }

    public boolean contains(Location loc) {
        if (!loc.getWorld().equals((Object)this.min.getWorld())) {
            return false;
        }
        return loc.getBlockX() >= this.min.getBlockX() && loc.getBlockX() <= this.max.getBlockX() && loc.getBlockY() >= this.min.getBlockY() && loc.getBlockY() <= this.max.getBlockY() && loc.getBlockZ() >= this.min.getBlockZ() && loc.getBlockZ() <= this.max.getBlockZ();
    }

    public boolean getPlayerWasActive() {
        return this.playerWasActive;
    }

    public void setPlayerWasActive(boolean regionPlayerWasActive) {
        this.playerWasActive = regionPlayerWasActive;
    }

    public String getCoOwner() {
        return this.coOwner;
    }

    public void setCoOwner(String regionCoOwner) {
        this.coOwner = regionCoOwner;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean regionActive) {
        this.active = regionActive;
    }

    public Set<UUID> getBuilders() {
        return Collections.unmodifiableSet(this.builders);
    }

    public void addBuilder(UUID uuid) {
        this.builders.add(uuid);
    }

    public void removeBuilder(UUID uuid) {
        this.builders.remove(uuid);
    }

    public boolean isBuilder(UUID uuid) {
        return this.builders.contains(uuid);
    }

    public boolean isFree() {
        return this.isFree;
    }

    public void setFree(boolean free) {
        this.isFree = free;
    }

    public boolean isBuyable() {
        return this.buyable;
    }

    public void setBuyable(boolean regionBuyable) {
        this.buyable = regionBuyable;
    }

    public void setInteraction(String type, boolean allowed) {
        this.interactionPermissions.put(type, allowed);
    }

    public boolean getInteraction(String type) {
        return this.interactionPermissions.getOrDefault(type, false);
    }

    public Map<String, Boolean> getInteractionPermissions() {
        return Collections.unmodifiableMap(this.interactionPermissions);
    }

    public void setInteractionPermissions(Map<String, Boolean> interactions) {
        this.interactionPermissions = new HashMap<String, Boolean>(interactions);
    }

    public String getName() {
        return this.name;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID regionOwner) {
        this.owner = regionOwner;
    }

    public Location getMin() {
        return this.min;
    }

    public Location getMax() {
        return this.max;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double regionPrice) {
        this.price = regionPrice;
    }

    public boolean isRentable() {
        return this.isRentable;
    }

    public void setRentable(boolean rentable) {
        this.isRentable = rentable;
    }

    public int getMinY() {
        return this.min.getBlockY();
    }

    public int getMaxY() {
        return this.max.getBlockY();
    }

    public List<UUID> getStaff() {
        return this.staff;
    }

    public void setStaff(List<UUID> staffList) {
        this.staff.clear();
        if (staffList != null) {
            this.staff.addAll(staffList);
        }
    }

    public List<BlockStateData> getSavedBlocks() {
        return Collections.unmodifiableList(this.savedBlocks);
    }

    public void setSavedBlocks(List<BlockStateData> savedRegionBlocks) {
        this.savedBlocks = new ArrayList<BlockStateData>(savedRegionBlocks);
    }

    public double getUserPrice() {
        return this.userPrice;
    }

    public void setUserPrice(double newUserPrice) {
        this.userPrice = newUserPrice;
    }

    public boolean isUserOffer() {
        return this.userOffer;
    }

    public void setUserOffer(boolean offer) {
        this.userOffer = offer;
    }

    public void addSign(Location loc) {
        if (!this.signs.contains(loc)) {
            this.signs.add(loc);
        }
    }

    public void removeSign(Location loc) {
        this.signs.remove(loc);
    }

    public List<Location> getSigns() {
        return Collections.unmodifiableList(this.signs);
    }

    public void setSigns(List<Location> loadedSigns) {
        this.signs.clear();
        if (loadedSigns != null) {
            this.signs.addAll(loadedSigns);
        }
    }

    public int getSpeedLevel() {
        return this.speedLevel;
    }

    public void setSpeedLevel(int regionSpeedLevel) {
        this.speedLevel = regionSpeedLevel;
    }

    public static class Builder {
        private String name;
        private UUID owner;
        private String coOwner;
        private Location pos1;
        private Location pos2;
        private double price = 1000.0;
        private boolean rentable = false;
        private boolean playerWasActive = false;
        private int speedLevel = 1;

        public Builder name(String pName) {
            this.name = pName;
            return this;
        }

        public Builder owner(UUID pOwner) {
            this.owner = pOwner;
            return this;
        }

        public Builder coOwner(String pCoOwner) {
            this.coOwner = pCoOwner;
            return this;
        }

        public Builder pos1(Location pPos1) {
            this.pos1 = pPos1;
            return this;
        }

        public Builder pos2(Location pPos2) {
            this.pos2 = pPos2;
            return this;
        }

        public Builder price(double pPrice) {
            this.price = pPrice;
            return this;
        }

        public Builder rentable(boolean pRentable) {
            this.rentable = pRentable;
            return this;
        }

        public Builder playerWasActive(boolean pActive) {
            this.playerWasActive = pActive;
            return this;
        }

        public Builder speedLevel(int pLevel) {
            this.speedLevel = pLevel;
            return this;
        }

        public Region build() {
            if (this.name == null || this.owner == null || this.coOwner == null || this.pos1 == null || this.pos2 == null) {
                throw new IllegalArgumentException("Es wurden nicht alle n\u00f6tigen Felder des Region.Builders gesetzt.");
            }
            return new Region(this);
        }
    }
}

