/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools.Ampeln;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;

public class Ampel
implements ConfigurationSerializable {
    private final Location loc;
    private AmpelType type;

    public Ampel(Location loc, AmpelType type) {
        this.loc = loc;
        this.type = type;
    }

    public Ampel(Map<String, Object> map) {
        this.loc = (Location)map.get("location");
        this.type = AmpelType.valueOf((String)map.get("type"));
    }

    public Location getLocation() {
        return this.loc;
    }

    public AmpelType getType() {
        return this.type;
    }

    public void setType(AmpelType type) {
        this.type = type;
    }

    public final Block getRed() {
        return this.loc.clone().subtract(0.0, 1.0, 0.0).getBlock();
    }

    public final Block getYellow() {
        return this.loc.clone().subtract(0.0, 2.0, 0.0).getBlock();
    }

    public final Block getGreen() {
        return this.loc.clone().subtract(0.0, 3.0, 0.0).getBlock();
    }

    public final boolean isChunkLoaded() {
        return this.loc.getWorld().isChunkLoaded(this.loc.getBlockX() >> 4, this.loc.getBlockZ() >> 4);
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", this.loc);
        map.put("type", this.type.name());
        return map;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ampel ampel = (Ampel)o;
        return Objects.equals(this.loc, ampel.loc);
    }

    public int hashCode() {
        return Objects.hash(this.loc);
    }

    public static enum AmpelType {
        NORTH_SOUTH,
        EAST_WEST;

    }
}

