/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools.Ampeln;

import de.flipper1406.futureleague_wirtschaft.FuncUtils;
import de.flipper1406.futureleague_wirtschaft.FutureLeague_Wirtschaft;
import de.flipper1406.futureleague_wirtschaft.Tools.Ampeln.Ampel;
import de.flipper1406.futureleague_wirtschaft.Tools.Ampeln.AmpelCommand;
import de.flipper1406.futureleague_wirtschaft.Tools.Ampeln.AmpelFileManager;
import de.flipper1406.futureleague_wirtschaft.Tools.Ampeln.AmpelRunnable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class AmpelManager {
    private final FutureLeague_Wirtschaft plugin;
    private final List<Ampel> ampeln;
    private AmpelCommand ampelCommand;
    private AmpelRunnable ampelRunnable;
    private AmpelFileManager fileManager;

    public AmpelManager(FutureLeague_Wirtschaft wirtschaftsPlugin) throws IOException, InvalidConfigurationException {
        this.plugin = wirtschaftsPlugin;
        ConfigurationSerialization.registerClass(Ampel.class);
        this.fileManager = new AmpelFileManager(wirtschaftsPlugin);
        List<Ampel> loadedAmpeln = this.fileManager.loadAmpeln();
        this.ampeln = Collections.synchronizedList(loadedAmpeln);
    }

    public void enable() {
        this.ampelCommand = new AmpelCommand(this);
        this.plugin.getCommand("ampel").setExecutor((CommandExecutor)this.ampelCommand);
        this.plugin.getCommand("ampel").setTabCompleter((TabCompleter)this.ampelCommand);
        this.ampelRunnable = new AmpelRunnable(this);
        this.ampelRunnable.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        List<Ampel> list = this.ampeln;
        synchronized (list) {
            this.fileManager.saveAmpeln(this.ampeln);
        }
    }

    public void addAmpel(Location loc, Ampel.AmpelType type) {
        if (this.isAmpel(loc)) {
            throw new IllegalArgumentException("Die \u00fcbergebene Location ist bereits als Ampel registriert.");
        }
        this.ampeln.add(new Ampel(loc.getBlock().getLocation(), type));
    }

    public void removeAmpel(Location loc) {
        Ampel ampel = (Ampel)this.ampeln.stream().filter(a -> a.getLocation().equals((Object)loc.getBlock().getLocation())).collect(FuncUtils.toSingleton());
        if (ampel == null) {
            throw new IllegalArgumentException("Die \u00fcbergebene Location ist nicht als Ampel registriert.");
        }
        this.ampeln.remove(ampel);
    }

    public boolean isAmpel(Location loc) {
        return this.ampeln.stream().anyMatch(a -> a.getLocation().equals((Object)loc.getBlock().getLocation()));
    }

    public void setAusrichtung(Location loc, Ampel.AmpelType type) {
        Ampel ampel = (Ampel)this.ampeln.stream().filter(a -> a.getLocation().equals((Object)loc.getBlock().getLocation())).collect(FuncUtils.toSingleton());
        if (ampel == null) {
            throw new IllegalArgumentException("Die \u00fcbergebene Location ist nicht als Ampel registriert.");
        }
        ampel.setType(type);
    }

    List<Ampel> getAmpeln() {
        return this.ampeln;
    }

    public FutureLeague_Wirtschaft getPlugin() {
        return this.plugin;
    }
}

