/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.General;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class OpenBothDoors
implements Listener {
    private final JavaPlugin plugin;

    public OpenBothDoors(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block[] neighbors;
        if (event.getClickedBlock() == null) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        Material type = clickedBlock.getType();
        if (!this.isDoor(type)) {
            return;
        }
        BlockData blockData = clickedBlock.getBlockData();
        if (!(blockData instanceof Openable)) {
            return;
        }
        Openable clickedOpenable = (Openable)blockData;
        boolean newState = !clickedOpenable.isOpen();
        clickedOpenable.setOpen(newState);
        clickedBlock.setBlockData((BlockData)clickedOpenable);
        final ArrayList<Block> affectedDoors = new ArrayList<Block>();
        affectedDoors.add(clickedBlock);
        for (Block neighbor : neighbors = new Block[]{clickedBlock.getRelative(1, 0, 0), clickedBlock.getRelative(-1, 0, 0), clickedBlock.getRelative(0, 0, 1), clickedBlock.getRelative(0, 0, -1)}) {
            BlockData blockData2;
            if (neighbor.getType() != type || !((blockData2 = neighbor.getBlockData()) instanceof Openable)) continue;
            Openable neighborOpenable = (Openable)blockData2;
            neighborOpenable.setOpen(newState);
            neighbor.setBlockData((BlockData)neighborOpenable);
            affectedDoors.add(neighbor);
        }
        if (newState) {
            new BukkitRunnable(){

                public void run() {
                    for (Block door : affectedDoors) {
                        Openable autoCloseable;
                        BlockData blockData = door.getBlockData();
                        if (!(blockData instanceof Openable) || !(autoCloseable = (Openable)blockData).isOpen()) continue;
                        autoCloseable.setOpen(false);
                        door.setBlockData((BlockData)autoCloseable);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 100L);
        }
    }

    private boolean isDoor(Material material) {
        return material.name().endsWith("_DOOR");
    }
}

