/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Regions;

import de.flipper1406.futureleague_wirtschaft.FutureLeague_Wirtschaft;
import de.flipper1406.futureleague_wirtschaft.Regions.Region;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionManager;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatInput
implements Listener {
    private static final int MAX_REGION_PRICE = 999999999;
    private static final int MIN_REGION_PRICE = 0;
    public static final Map<UUID, ChatAction> WAITING_FOR_PLAYER = new HashMap<UUID, ChatAction>();

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        if (!WAITING_FOR_PLAYER.containsKey(uuid)) {
            return;
        }
        e.setCancelled(true);
        Bukkit.getScheduler().runTask((Plugin)FutureLeague_Wirtschaft.instance, () -> {
            ChatAction action = WAITING_FOR_PLAYER.remove(uuid);
            if (action != null) {
                action.handleInput(e.getPlayer(), e.getMessage());
            }
        });
    }

    public static interface ChatAction {
        public void handleInput(Player var1, String var2);
    }

    public static class SetPrice
    implements ChatAction {
        private final Region region;

        public SetPrice(Region regionName) {
            this.region = regionName;
        }

        @Override
        public void handleInput(Player player, String input) {
            try {
                double price = Double.parseDouble(input);
                String formattedPrice = NumberFormat.getCurrencyInstance(Locale.GERMANY).format(price);
                if (price < 0.0) {
                    player.sendMessage("\u00a7cDer Preis darf nicht negativ sein. Gebe einen anderen Betrag ein:");
                    WAITING_FOR_PLAYER.put(player.getUniqueId(), this);
                    return;
                }
                if (price > 9.99999999E8) {
                    player.sendMessage("\u00a7cDer Preis muss kleiner als 1 Milliarde sein. Gebe einen anderen Betrag ein:");
                    WAITING_FOR_PLAYER.put(player.getUniqueId(), this);
                    return;
                }
                if (this.region.isUserOffer()) {
                    this.region.setUserPrice(price);
                } else {
                    this.region.setPrice(price);
                }
                RegionManager.getInstance().saveRegion(this.region);
                RegionManager.getInstance().updateSignStatus(this.region);
                player.sendMessage("\u00a7aDer Preis wurde auf " + formattedPrice + " gesetzt.");
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7cBitte gib eine g\u00fcltige Zahl ein.");
                WAITING_FOR_PLAYER.put(player.getUniqueId(), this);
            }
        }
    }
}

