/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public final class PlacedBlockDatabase {
    private static final int FIRST_PARAMETER_INDEX = 1;
    private static final int SECCOND_PARAMETER_INDEX = 2;
    private static final int THIRD_PARAMETER_INDEX = 3;
    private static final int FOURTH_PARAMETER_INDEX = 4;
    private static final int FIFTH_PARAMETER_INDEX = 5;
    private static final int SIXTH_PARAMETER_INDEX = 6;
    private static File dbFile;

    private PlacedBlockDatabase() {
    }

    public static void init(File pluginFolder) throws SQLException {
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        dbFile = new File(pluginFolder, "blocks.db");
        try (Connection conn = PlacedBlockDatabase.getNewConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("    CREATE TABLE IF NOT EXISTS placed_blocks (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        player_uuid TEXT,\n        material TEXT,\n        world TEXT,\n        x INTEGER,\n        y INTEGER,\n        z INTEGER,\n        time TIMESTAMP DEFAULT CURRENT_TIMESTAMP\n    )\n");
        }
    }

    public static Connection getNewConnection() throws SQLException {
        if (dbFile == null) {
            throw new SQLException("Database file not initialized \u2013 call placedBlockDatabase.init(...) first");
        }
        String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
        return DriverManager.getConnection(url);
    }

    /*
     * Exception decompiling
     */
    public static boolean isBlockStored(String world, int x, int y, int z) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void insertPlacedBlock(String playerUUID, String material, String world, int x, int y, int z) {
        String sql = "INSERT INTO placed_blocks (player_uuid, material, world, x, y, z) VALUES (?,?,?,?,?,?)";
        try (Connection conn = PlacedBlockDatabase.getNewConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, playerUUID);
            ps.setString(2, material);
            ps.setString(3, world);
            ps.setInt(4, x);
            ps.setInt(5, y);
            ps.setInt(6, z);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void clearAllBlocks() {
        String sql = "DELETE FROM placed_blocks";
        try (Connection conn = PlacedBlockDatabase.getNewConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.executeUpdate();
            System.out.println("[FutureLeague_Wirtschaft] Alle Eintr\u00e4ge in placed_blocks wurden gel\u00f6scht.");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

