/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Regions;

import de.flipper1406.futureleague_wirtschaft.Regions.BlockStateData;
import de.flipper1406.futureleague_wirtschaft.Regions.BlockStorage;
import de.flipper1406.futureleague_wirtschaft.Regions.Region;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionManager;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionSelectionTool;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RegionCommand
implements CommandExecutor {
    private final File regionDataFolder;
    private static final int SPEED_ARGUMENT_COUNT = 3;
    private static final int MAX_SPEED_LEVEL = 5;
    private final String currency = " Euro";

    public RegionCommand(File dataFolder) {
        this.regionDataFolder = dataFolder;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendUsage(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "tool": {
                this.handleTool(player);
                break;
            }
            case "list": {
                this.handleList(player);
                break;
            }
            case "define": {
                this.handleDefine(player, args);
                break;
            }
            case "reset": {
                this.handleReset(player);
                break;
            }
            case "delete": {
                this.handleDelete(player, args);
                break;
            }
            case "info": {
                this.handleInfo(player);
                break;
            }
            case "speed": {
                this.handleSpeed(player, args);
                break;
            }
            default: {
                this.sendUsage(player);
            }
        }
        return true;
    }

    private void handleTool(Player player) {
        ItemStack axe = new ItemStack(Material.DIAMOND_AXE);
        ItemMeta meta = axe.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Region-Tool");
        axe.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{axe});
        player.sendMessage("\u00a72Du hast das Region-Tool erhalten.");
    }

    private void handleList(Player player) {
        Set<String> regionNames = RegionManager.getInstance().getAllRegionNames();
        player.sendMessage("\u00a72<><><> \u00a76Fl Regions (\u00dcbersicht) \u00a72<><><>");
        regionNames.forEach(name -> player.sendMessage(String.valueOf(ChatColor.GRAY) + "- " + String.valueOf(ChatColor.GOLD) + name));
    }

    private void handleDefine(Player player, String[] args) {
        if (args.length != 2) {
            return;
        }
        if (!RegionSelectionTool.hasBoth(player)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Du musst zuerst beide Positionen mit dem Tool setzen.");
            return;
        }
        String name = args[1].toLowerCase();
        if (RegionManager.getInstance().getRegion(name) != null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Eine Region mit dem Namen '" + name + "' existiert bereits.");
            return;
        }
        Location pos1 = RegionSelectionTool.getPos1(player);
        Location pos2 = RegionSelectionTool.getPos2(player);
        Region region = new Region.Builder().name(name).owner(player.getUniqueId()).coOwner("FL").pos1(pos1).pos2(pos2).playerWasActive(true).build();
        region.setFree(true);
        region.setBuyable(true);
        region.setActive(true);
        List<BlockStateData> savedBlocks = RegionManager.getInstance().saveRegionBlocks(region);
        region.setSavedBlocks(savedBlocks);
        RegionManager.getInstance().addRegion(region);
        RegionManager.getInstance().saveRegion(region);
        BlockStorage blockStorage = new BlockStorage(name, this.regionDataFolder);
        blockStorage.saveBlocks(region);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Region '" + name + "' wurde erstellt und gespeichert.");
    }

    private void handleReset(Player player) {
        if (!player.hasPermission("fl.region.admin")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Dazu hast du keine Berechtigung.");
            return;
        }
        Region region = RegionManager.getInstance().getRegion(player.getLocation());
        RegionManager.getInstance().resetRegion(region, player);
    }

    private void handleDelete(Player player, String[] args) {
        if (args.length != 2) {
            return;
        }
        String regionName = args[1].toLowerCase();
        Region region = RegionManager.getInstance().getRegion(regionName);
        if (region == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Region '" + regionName + "' wurde nicht gefunden.");
            return;
        }
        if (!region.getOwner().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Du bist nicht der Besitzer dieser Region.");
            return;
        }
        BlockStorage blockStorage = new BlockStorage(regionName, this.regionDataFolder);
        blockStorage.deleteBlockFile();
        RegionManager.getInstance().removeRegion(regionName);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Region '" + regionName + "' wurde gel\u00f6scht.");
    }

    private void handleInfo(Player player) {
        if (!player.hasPermission("fl.region.admin")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Dazu hast du keine Berechtigung.");
            return;
        }
        Region region = RegionManager.getInstance().getRegion(player.getLocation());
        if (region == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Du befindest dich in keiner Region.");
            return;
        }
        this.sendRegionInfo(player, region);
    }

    private void handleSpeed(Player player, String[] args) {
        int speedLevel;
        if (args.length != 3) {
            return;
        }
        if (!player.hasPermission("fl.regions.admin")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Dazu hast du keine Rechte.");
            return;
        }
        String regionName = args[1].toLowerCase();
        try {
            speedLevel = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Bitte eine g\u00fcltige Zahl zwischen 1 und 5 eingeben.");
            return;
        }
        if (speedLevel < 1 || speedLevel > 5) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Die Geschwindigkeit muss zwischen 1 und 5 liegen.");
            return;
        }
        RegionManager regionManager = RegionManager.getInstance();
        Region region = regionManager.getRegion(regionName);
        if (region == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Region nicht gefunden.");
            return;
        }
        regionManager.setSpeedLevel(regionName, speedLevel);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Speed-Level der Region '" + regionName + "' wurde auf " + speedLevel + " gesetzt.");
        Bukkit.getOnlinePlayers().forEach(p -> {
            if (region.contains(p.getLocation())) {
                regionManager.updatePlayerSpeed((Player)p);
            }
        });
    }

    private void sendUsage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.RED) + "Verwendung: /reg tool oder /reg define <Name> oder /reg speed <Region> <1-5>");
    }

    private void sendRegionInfo(Player p, Region region) {
        if (region.isUserOffer()) {
            p.sendMessage(String.valueOf(ChatColor.GRAY) + "=== Region: " + String.valueOf(ChatColor.GOLD) + region.getName() + String.valueOf(ChatColor.GRAY) + " ===");
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Besitzer: " + String.valueOf(ChatColor.WHITE) + Bukkit.getOfflinePlayer((UUID)region.getOwner()).getName());
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Preis: " + String.valueOf(ChatColor.WHITE) + region.getPrice() + " Euro");
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Angebotspreis des Spielers: " + String.valueOf(ChatColor.WHITE) + region.getUserPrice() + " Euro");
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Art: " + (region.isRentable() ? String.valueOf(ChatColor.GREEN) + "Miete" : String.valueOf(ChatColor.AQUA) + "Kauf"));
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Y-Min: " + String.valueOf(ChatColor.WHITE) + region.getMinY() + " || \u00a7eY-Max: \u00a7f" + region.getMaxY());
        } else {
            String besitzer = "";
            String cobesitzer = "";
            besitzer = region.getOwner() == null ? "Frei" : Bukkit.getOfflinePlayer((UUID)region.getOwner()).getName();
            p.sendMessage(String.valueOf(ChatColor.GRAY) + "=== Region: " + String.valueOf(ChatColor.GOLD) + region.getName() + String.valueOf(ChatColor.GRAY) + " ===");
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Besitzer: " + String.valueOf(ChatColor.WHITE) + besitzer);
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Preis: " + String.valueOf(ChatColor.WHITE) + region.getPrice() + " Euro");
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Art: " + (region.isRentable() ? String.valueOf(ChatColor.GREEN) + "Miete" : String.valueOf(ChatColor.AQUA) + "Kauf"));
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Y-Min: " + String.valueOf(ChatColor.WHITE) + region.getMinY() + " || \u00a7eY-Max: \u00a7f" + region.getMaxY());
        }
    }
}

