/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Regions;

import de.flipper1406.futureleague_wirtschaft.Regions.Region;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionManager;
import de.flipper1406.futureleague_wirtschaft.Userdata.Utils.UserDataManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RegionPurchaseGUI
implements Listener {
    private static final Map<UUID, Region> OPEN_INVENTORIES = new HashMap<UUID, Region>();
    private static final double TAX_PERCENTAGE = 10.0;
    private static final double PERCENT_DIVISOR = 100.0;
    private static final int SLOT_NUMBER_13 = 13;
    private static final int SLOT_NUMBER_11 = 11;
    private static final int SLOT_NUMBER_15 = 15;
    private static final int INVENTORY_STANDARD_SIZE = 27;

    public static void open(Player player, Region region) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"Region kaufen/mieten");
        ItemStack paper = new ItemStack(Material.PAPER);
        ItemMeta meta = paper.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Region Info");
        meta.setLore(List.of(String.valueOf(ChatColor.YELLOW) + "Region: " + String.valueOf(ChatColor.WHITE) + region.getName(), String.valueOf(ChatColor.YELLOW) + "Preis: " + String.valueOf(ChatColor.WHITE) + region.getPrice() + " Euro", String.valueOf(ChatColor.YELLOW) + "Y-Min: " + String.valueOf(ChatColor.WHITE) + region.getMinY(), String.valueOf(ChatColor.YELLOW) + "Y-Max: " + String.valueOf(ChatColor.WHITE) + region.getMaxY()));
        paper.setItemMeta(meta);
        inv.setItem(13, paper);
        ItemStack buyWool = new ItemStack(Material.GREEN_WOOL);
        ItemMeta buyMeta = buyWool.getItemMeta();
        buyMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "ja, Region kaufen");
        buyWool.setItemMeta(buyMeta);
        inv.setItem(11, buyWool);
        ItemStack rentWool = new ItemStack(Material.RED_WOOL);
        ItemMeta rentMeta = rentWool.getItemMeta();
        rentMeta.setDisplayName(String.valueOf(ChatColor.RED) + "nein, Region nicht kaufen");
        rentWool.setItemMeta(rentMeta);
        inv.setItem(15, rentWool);
        player.openInventory(inv);
        OPEN_INVENTORIES.put(player.getUniqueId(), region);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = ChatColor.stripColor((String)event.getView().getTitle());
        if (!title.equals("Region kaufen/mieten")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        Region region = OPEN_INVENTORIES.get(player.getUniqueId());
        if (region == null) {
            player.closeInventory();
            return;
        }
        String displayName = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
        UUID playerUUID = player.getUniqueId();
        if (displayName.contains("ja")) {
            if (!region.isBuyable()) {
                double balance = UserDataManager.getBalance(playerUUID);
                if (balance >= region.getPrice()) {
                    UserDataManager.removeBalance(playerUUID, region.getPrice());
                    UserDataManager.logTransactionAsSend(playerUUID, region.getPrice(), "Mieten der Region: " + region.getName(), "FL Immobilien");
                    region.setCoOwner(Bukkit.getPlayer((UUID)playerUUID).getName());
                    region.setFree(false);
                    Bukkit.getPlayer((UUID)playerUUID).sendMessage("\u00a72Du hast die Region " + region.getName() + " erfolgreich gemietet und die erste Miete gezahlt.");
                    Bukkit.getPlayer((UUID)playerUUID).sendMessage("\u00a72Ab sofort zahlst du w\u00f6chentlich Montags um 12 Uhr deine Miete sofern du in der Woche zuvor aktiv warst!");
                    player.closeInventory();
                    RegionManager.getInstance().saveRegion(region);
                    RegionManager.getInstance().updateSignStatus(region);
                }
                return;
            }
            double balance = UserDataManager.getBalance(playerUUID);
            if (region.isUserOffer()) {
                if (balance >= region.getUserPrice()) {
                    this.handleUserRegionPurchase(player, playerUUID, region);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Du hast nicht genug Geld f\u00fcr den Kauf.");
                }
            } else if (balance >= region.getPrice()) {
                UserDataManager.removeBalance(playerUUID, region.getPrice());
                UserDataManager.logTransactionAsSend(playerUUID, region.getPrice(), "Region gekauft: " + region.getName(), "FL Immobilien");
                region.setOwner(playerUUID);
                region.setFree(false);
                region.setStaff(null);
                RegionManager.getInstance().saveRegion(region);
                player.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "Du hast die Region erfolgreich gekauft und " + String.valueOf(ChatColor.GREEN) + region.getPrice() + " bezahlt!");
                player.closeInventory();
                OPEN_INVENTORIES.remove(playerUUID);
            } else {
                player.sendMessage("\u00a7cDu hast nicht genug Geld f\u00fcr den Kauf.");
            }
        } else if (displayName.contains("nein")) {
            if (!region.isRentable()) {
                player.closeInventory();
                player.sendMessage("\u00a7cDu hast die Region nicht gekauft.");
                return;
            }
            double balance = UserDataManager.getBalance(playerUUID);
            if (balance >= region.getPrice()) {
                UserDataManager.removeBalance(playerUUID, region.getPrice());
                UserDataManager.logTransaction(playerUUID, null, region.getPrice(), "Region gemietet: " + region.getName());
                region.setCoOwner(Bukkit.getPlayer((UUID)playerUUID).getName());
                region.setStaff(null);
                RegionManager.getInstance().saveRegion(region);
                player.sendMessage("\u00a72Du hast die Region erfolgreich gemietet!");
                player.closeInventory();
                OPEN_INVENTORIES.remove(playerUUID);
            } else {
                player.sendMessage("\u00a7cDu hast nicht genug Geld f\u00fcr die Miete.");
            }
        }
    }

    private void handleUserRegionPurchase(Player player, UUID playerUUID, Region region) {
        double tax = region.getUserPrice() * 0.1;
        Player oldRegionOwner = Bukkit.getPlayer((UUID)region.getOwner());
        UserDataManager.removeBalance(playerUUID, region.getUserPrice());
        UserDataManager.removeBalance(oldRegionOwner.getUniqueId(), tax);
        UserDataManager.addBalance(oldRegionOwner.getUniqueId(), region.getUserPrice());
        UserDataManager.logTransactionAsSend(playerUUID, region.getUserPrice(), "Region gekauft: " + region.getName(), oldRegionOwner.getName());
        UserDataManager.logTransactionAsSend(oldRegionOwner.getUniqueId(), tax, "Immobilien-Steuer ", "FL Network");
        UserDataManager.logTransactionAsReceipt(oldRegionOwner.getUniqueId(), playerUUID, region.getUserPrice(), "Abkaufen der Region: " + region.getName());
        region.setOwner(playerUUID);
        region.setFree(false);
        region.setUserOffer(false);
        region.setStaff(null);
        RegionManager.getInstance().saveRegion(region);
        player.sendMessage("\u00a72Du hast die Region erfolgreich gekauft!");
        oldRegionOwner.sendMessage("\u00a72Du hast die Region erfolgreich verkauft!");
        player.closeInventory();
        OPEN_INVENTORIES.remove(playerUUID);
    }
}

