/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Jobs.Commands;

import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileExp;
import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigFileJobs;
import de.flipper1406.futureleague_wirtschaft.ConfigManager.ConfigManager;
import de.flipper1406.futureleague_wirtschaft.FLAPI;
import de.flipper1406.futureleague_wirtschaft.Jobs.Feuerwehr.Einsatz1;
import de.flipper1406.futureleague_wirtschaft.futureLeagueWirtschaft;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class JobCommands
implements Listener,
CommandExecutor {
    private final ConfigManager configManager;
    private final FLAPI flapi;
    private final ConfigFileJobs configFileJobs;
    private final ConfigFileExp configFileExp;
    private final Einsatz1 einsatz1;
    private final String prefixTitle = "Job-System";
    private futureLeagueWirtschaft plugin;
    private final Material[] jobMaterials = new Material[]{Material.FISHING_ROD, Material.WATER_BUCKET, Material.BRUSH, Material.DIAMOND_SWORD, Material.DIAMOND_PICKAXE, Material.WOODEN_AXE, Material.IRON_HOE, Material.POPPY, Material.POTION, Material.CAKE};

    public JobCommands(futureLeagueWirtschaft plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.einsatz1 = plugin.getEinsatz1();
        this.flapi = plugin.getflapi();
        this.configFileJobs = plugin.getConfigFileJobs();
        this.configFileExp = plugin.getConfigFileExp();
    }

    private void helpPage(Player p) {
        this.flapi.sendPrefixMessage(p, "Job-System");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs join \u00a7aum einen neuen Job anzunehmen.");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs leave \u00a7aum deinen aktuellen Job zu k\u00fcndigen.");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs status \u00a7aum deinen aktuellen Job-Status einzusehen.");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs help \u00a7aum diese Hilfe-Seite zu \u00f6ffnen.");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs info \u00a7aum weitere Informationen zu einem Job zu erhalten.");
        p.sendMessage(" \u00a7aBenutze \u00a72/jobs list \u00a7aum eine Liste aller Jobs zu erhalten.");
        p.sendMessage("");
        p.sendMessage(" \u00a72Beim Verlassen des Netzwerks, wird dein aktueller Job automatisch gek\u00fcndigt. Du kannst aber jederzeit einen neuen Job annehmen.");
        this.flapi.sendSuffixMessage(p);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (cmd.getName().equalsIgnoreCase("jobs")) {
                if (args.length == 0) {
                    this.helpPage(p);
                }
                if (args.length == 1) {
                    if (args[0].equalsIgnoreCase("join")) {
                        if (!this.configManager.checkForPlayerInConfig(p.getName())) {
                            this.configManager.setValue(p.getName(), "currentJob", "Arbeitslos");
                            this.configManager.setValue(p.getName(), "hasJob", false);
                        }
                        if (this.configManager.getValue(p.getName(), "hasJob", true)) {
                            this.flapi.sendPrefixMessage(p, "Job-System");
                            p.sendMessage(" \u00a72<> \u00a7aDu besitzt bereits einen Job: \u00a72" + this.configManager.getValue(p.getName(), "currentJob"));
                            this.flapi.sendSuffixMessage(p);
                        } else {
                            Inventory inventory = Bukkit.createInventory(null, (int)27, (String)this.configFileJobs.getInventoryTitle());
                            for (int i = 0; i < this.configFileJobs.getJobName().size(); ++i) {
                                inventory.setItem(i, this.flapi.getItemForJobInventory(new ItemStack(this.jobMaterials[i]), this.configFileJobs.getJobName().get(i), this.configFileJobs.getBezeichnung().get(i)));
                            }
                            p.openInventory(inventory);
                        }
                    } else if (args[0].equalsIgnoreCase("leave")) {
                        if (!this.configManager.getValue(p.getName(), "hasJob", true)) {
                            this.flapi.sendPrefixMessage(p, "Job-System");
                            p.sendMessage(" \u00a72<> \u00a7aDu hast noch keinen Job. Beginne einen mit \u00a72/jobs join");
                            this.flapi.sendSuffixMessage(p);
                        } else {
                            this.flapi.sendPrefixMessage(p, "Job-System");
                            p.sendMessage(" \u00a72<> \u00a72Du hast deinen Job \u00a7a" + this.configManager.getValue(p.getName(), "currentJob") + " \u00a72gek\u00fcndigt!");
                            this.flapi.sendSuffixMessage(p);
                            this.configManager.setValue(p.getPlayer().getName(), "hasJob", false);
                            this.configManager.setValue(p.getPlayer().getName(), "currentJob", "Arbeitslos");
                            this.configManager.setValue(p.getPlayer().getName(), "onMission", false);
                        }
                    } else if (args[0].equalsIgnoreCase("status")) {
                        int aktuellesLevel = this.flapi.getJobLevel(p);
                        int aktuellesEXP = this.flapi.getJobEXP(p);
                        List<Integer> levels = this.configFileExp.getLevelSteps();
                        int nextEXP = levels.get(aktuellesLevel);
                        this.flapi.sendPrefixMessage(p, "Job-System");
                        p.sendMessage(" \u00a72<> \u00a72Aktueller Job: \u00a7a" + this.configManager.getValue(p.getName(), "currentJob"));
                        if (!this.configManager.getValue(p.getName(), "currentJob").equalsIgnoreCase("Arbeitslos")) {
                            double percentage = (double)aktuellesEXP / (double)nextEXP * 100.0;
                            percentage = this.flapi.rint(percentage, 2);
                            p.sendMessage(" \u00a72<> \u00a72Aktuelles Level: \u00a7a" + aktuellesLevel);
                            p.sendMessage(" \u00a72<> \u00a72Fortschritt zum n\u00e4chsten Level: \u00a7a" + percentage + "\u00a72%");
                        }
                        this.flapi.sendSuffixMessage(p);
                    } else if (args[0].equalsIgnoreCase("info")) {
                        this.flapi.sendPrefixMessage(p, "Job-System");
                        p.sendMessage(" \u00a72<> \u00a7aErhalte weitere Informationen zu einem Job mit \u00a72/jobs info <JobName>");
                        this.flapi.sendSuffixMessage(p);
                    } else if (args[0].equalsIgnoreCase("list")) {
                        this.flapi.sendPrefixMessage(p, "Job-System");
                        p.sendMessage(" \u00a72Folgende Jobs sind verf\u00fcgbar:");
                        for (String jobName : this.configFileJobs.getJobName()) {
                            p.sendMessage(" \u00a7a- " + jobName);
                        }
                        this.flapi.sendSuffixMessage(p);
                    } else if (args[0].equalsIgnoreCase("belohnung") || args[0].equalsIgnoreCase("reward") || args[0].equalsIgnoreCase("belohnungen") || args[0].equalsIgnoreCase("rewards")) {
                        for (String jobName : this.configFileJobs.getJobName()) {
                            ItemStack item = this.flapi.getRewardItem(jobName, p);
                            if (!this.configManager.getRewards(p, jobName)) continue;
                            boolean invHasFreeSlot = false;
                            int slot = 0;
                            for (int i = 0; i <= 35; ++i) {
                                if (p.getInventory().getItem(i) != null) continue;
                                invHasFreeSlot = true;
                                slot = i;
                                i = 35;
                            }
                            boolean rewardGranted = false;
                            if (invHasFreeSlot) {
                                p.getInventory().setItem(slot, item);
                                rewardGranted = true;
                                this.flapi.sendMessage(p, "rewardSuccess");
                                this.configManager.setRewards(p, jobName, false);
                            } else {
                                this.flapi.sendMessage(p, "rewardErrorNoSpaceInInventory");
                            }
                            if (!rewardGranted) continue;
                            p.playSound(p.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 10.0f, 1.0f);
                        }
                    } else if (!args[0].equalsIgnoreCase("start")) {
                        if (args[0].equalsIgnoreCase("reset")) {
                            String worldName = "creative";
                            World world = Bukkit.getWorld((String)worldName);
                            Location loc1 = new Location(Bukkit.getWorld((String)worldName), -3988.0, 64.0, -3596.0);
                            Location loc2 = new Location(Bukkit.getWorld((String)worldName), -4002.0, 69.0, -3610.0);
                            this.flapi.placeBlocksInArea(loc1, loc2, Material.AIR);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 64.0, -3598.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 64.0, -3599.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 64.0, -3600.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 64.0, -3601.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 65.0, -3600.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 64.0, -3604.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 65.0, -3604.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 64.0, -3605.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 64.0, -3607.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3998.0, 64.0, -3606.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3998.0, 65.0, -3606.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3998.0, 64.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3998.0, 65.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3998.0, 64.0, -3600.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3998.0, 65.0, -3600.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3997.0, 64.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3997.0, 65.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3996.0, 64.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3996.0, 65.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 64.0, -3600.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 65.0, -3600.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 64.0, -3601.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 65.0, -3601.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 64.0, -3602.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 65.0, -3602.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 64.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 65.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 66.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 64.0, -3604.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 65.0, -3604.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 64.0, -3605.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 65.0, -3605.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3995.0, 64.0, -3606.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3994.0, 64.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3994.0, 65.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3993.0, 64.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3993.0, 65.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3993.0, 66.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3992.0, 64.0, -3606.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3992.0, 65.0, -3606.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3992.0, 64.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3992.0, 65.0, -3603.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3992.0, 64.0, -3600.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3992.0, 65.0, -3600.0)).setType(Material.BOOKSHELF);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3988.0, 64.0, -3596.0)).setType(Material.ANVIL);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3988.0, 64.0, -3610.0)).setType(Material.ANVIL);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 64.0, -3596.0)).setType(Material.ANVIL);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 64.0, -3610.0)).setType(Material.ANVIL);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3988.0, 65.0, -3596.0)).setType(Material.BEACON);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -3988.0, 65.0, -3610.0)).setType(Material.BEACON);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 65.0, -3596.0)).setType(Material.BEACON);
                            world.getBlockAt(new Location(Bukkit.getWorld((String)worldName), -4002.0, 65.0, -3610.0)).setType(Material.BEACON);
                            loc1 = new Location(Bukkit.getWorld((String)worldName), -3987.0, 67.0, -3601.0);
                            loc2 = new Location(Bukkit.getWorld((String)worldName), -3987.0, 64.0, -3605.0);
                            this.flapi.placeBlocksInArea(loc1, loc2, Material.AIR);
                            loc1 = new Location(Bukkit.getWorld((String)worldName), -3986.0, 68.0, -3597.0);
                            loc2 = new Location(Bukkit.getWorld((String)worldName), -3982.0, 64.0, -3609.0);
                            this.flapi.placeBlocksInArea(loc1, loc2, Material.AIR);
                        } else {
                            this.helpPage(p);
                        }
                    }
                }
                if (args.length >= 2 && args[0].equalsIgnoreCase("info")) {
                    boolean check = false;
                    for (int y = 0; y < this.configFileJobs.getJobName().size() - 1; ++y) {
                        if (!args[1].equalsIgnoreCase(this.configFileJobs.getJobName().get(y))) continue;
                        this.flapi.sendPrefixMessage(p, "Job-System");
                        p.sendMessage(" \u00a7a" + this.configFileJobs.getBezeichnung().get(y));
                        this.flapi.sendSuffixMessage(p);
                        check = !check;
                    }
                    if (!check) {
                        this.flapi.sendPrefixMessage(p, "Job-System");
                        p.sendMessage(" \u00a7cWir konnten den eingegebenen Job \u00a74" + args[1] + "\u00a7c nicht finden!");
                        p.sendMessage(" \u00a72Folgende Jobs sind verf\u00fcgbar:");
                        for (String jobName : this.configFileJobs.getJobName()) {
                            p.sendMessage(" \u00a7a- " + jobName);
                        }
                        this.flapi.sendSuffixMessage(p);
                    }
                }
            }
        }
        return true;
    }
}

