/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Regions;

import de.flipper1406.futureleague_wirtschaft.Regions.BlockStateData;
import de.flipper1406.futureleague_wirtschaft.Regions.ChatInput;
import de.flipper1406.futureleague_wirtschaft.Regions.InteractionSettingsGUI;
import de.flipper1406.futureleague_wirtschaft.Regions.Region;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionGUI;
import de.flipper1406.futureleague_wirtschaft.Regions.RegionManager;
import de.flipper1406.futureleague_wirtschaft.Userdata.Utils.UserDataManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;

public class InventoryClickListener
implements Listener {
    public static final Map<UUID, Region> PENDING_REGION_EDITOR = new HashMap<UUID, Region>();
    public static final Map<UUID, Region> INTERACTION_EDITING = new HashMap<UUID, Region>();
    private final double percentualRefund = 0.6;

    @EventHandler
    public final void onClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta() || !clicked.getItemMeta().hasDisplayName()) {
            return;
        }
        String rawTitle = ChatColor.stripColor((String)e.getView().getTitle());
        if (rawTitle.startsWith("Verwalte Region: ")) {
            e.setCancelled(true);
            String regionName = rawTitle.replace("Verwalte Region: ", "").toLowerCase();
            Region region = RegionManager.getInstance().getRegion(regionName);
            if (region != null) {
                this.handleMainGUI(p, clicked, region);
            }
        } else if (rawTitle.equalsIgnoreCase("Interaktionen")) {
            e.setCancelled(true);
            Region region = INTERACTION_EDITING.get(p.getUniqueId());
            if (region == null) {
                p.sendMessage("\u00a7cRegion konnte nicht geladen werden.");
                return;
            }
            String displayName = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
            if (displayName.contains("Truhen \u00f6ffnen")) {
                this.toggleInteraction(region, p, "truhen");
            } else if (displayName.contains("Redstone-Truhen")) {
                this.toggleInteraction(region, p, "redstone_truhen");
            } else if (displayName.contains("T\u00fcren \u00f6ffnen")) {
                this.toggleInteraction(region, p, "tueren");
            } else if (displayName.contains("Druckplatten")) {
                this.toggleInteraction(region, p, "druckplatten");
            } else if (displayName.contains("Kn\u00f6pfe benutzen")) {
                this.toggleInteraction(region, p, "knoepfe");
            } else if (displayName.equalsIgnoreCase("Zur\u00fcck")) {
                INTERACTION_EDITING.remove(p.getUniqueId());
                RegionGUI.open(p, region);
                return;
            }
            InteractionSettingsGUI.open(p, region);
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (ChatInput.WAITING_FOR_PLAYER.containsKey(uuid)) {
            return;
        }
        if (PENDING_REGION_EDITOR.containsKey(uuid)) {
            event.setCancelled(true);
            String message = event.getMessage().trim();
            Region region = PENDING_REGION_EDITOR.get(uuid);
            if (message.equalsIgnoreCase("stop")) {
                PENDING_REGION_EDITOR.remove(uuid);
                player.sendMessage("\u00a7cMitbauer-Verwaltung abgebrochen.");
                return;
            }
            if (message.equalsIgnoreCase("list")) {
                List<UUID> staff = region.getStaff();
                if (staff.isEmpty()) {
                    player.sendMessage("\u00a77Diese Region hat keine Mitbauer.");
                } else {
                    player.sendMessage("\u00a7eMitbauer dieser Region:");
                    for (UUID staffUUID : staff) {
                        OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)staffUUID);
                        player.sendMessage("\u00a78- \u00a7a" + op.getName());
                    }
                }
                return;
            }
            boolean remove = message.startsWith("-");
            String name = remove ? message.substring(1) : message;
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)name);
            if (target == null || target.getUniqueId() == null) {
                player.sendMessage("\u00a7cSpieler nicht gefunden: \u00a77" + name);
                return;
            }
            if (remove) {
                if (region.getStaff().remove(target.getUniqueId())) {
                    player.sendMessage("\u00a7c" + target.getName() + " wurde als Mitbauer entfernt.");
                    PENDING_REGION_EDITOR.remove(uuid);
                } else {
                    player.sendMessage("\u00a77" + target.getName() + " ist kein Mitbauer.");
                    PENDING_REGION_EDITOR.remove(uuid);
                }
            } else if (region.getStaff().contains(target.getUniqueId())) {
                player.sendMessage("\u00a77" + target.getName() + " ist bereits Mitbauer.");
                PENDING_REGION_EDITOR.remove(uuid);
            } else {
                region.getStaff().add(target.getUniqueId());
                player.sendMessage("\u00a7a" + target.getName() + " wurde als Mitbauer hinzugef\u00fcgt.");
                PENDING_REGION_EDITOR.remove(uuid);
            }
            RegionManager.getInstance().saveRegion(region);
        }
    }

    private void toggleInteraction(Region region, Player player, String key) {
        boolean current = region.getInteraction(key);
        region.setInteraction(key, !current);
        RegionManager.getInstance().saveRegion(region);
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Interaktion '" + key + "' ist jetzt " + (region.getInteraction(key) ? "\u00a7aaktiviert" : "\u00a7cdeaktiviert") + "\u00a7e.");
    }

    private void handleMainGUI(Player p, ItemStack clicked, Region region) {
        String displayName = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
        switch (displayName.toLowerCase()) {
            case "mitbauer verwalten": {
                PENDING_REGION_EDITOR.put(p.getUniqueId(), region);
                p.closeInventory();
                p.sendMessage("\u00a7eMitbauer-Verwaltung:");
                p.sendMessage("\u00a77Gib den Namen des Spielers im Chat ein.");
                p.sendMessage("\u00a78\u2022 \u00a76Name\u00a77 \u2192 Mitbauer hinzuf\u00fcgen");
                p.sendMessage("\u00a78\u2022 \u00a76-Name\u00a77 \u2192 Mitbauer entfernen");
                p.sendMessage("\u00a78\u2022 \u00a76list\u00a77 \u2192 Mitbauer auflisten");
                p.sendMessage("\u00a78\u2022 \u00a7cstop\u00a77 \u2192 Eingabe abbrechen");
                break;
            }
            case "verkaufen": {
                if (region.isUserOffer()) {
                    region.setUserOffer(false);
                    region.setFree(false);
                    p.closeInventory();
                    p.sendMessage("\u00a72Deine Region wird nun nicht mehr zum Verkauf angeboten.");
                } else {
                    RegionManager.getInstance().startPriceChange(p, region);
                    region.setFree(true);
                    region.setUserOffer(true);
                    p.sendMessage(String.valueOf(ChatColor.GREEN) + "Region " + region.getName() + " wird zum Verkauf angeboten. Gib nun den Preis im Chat ein.");
                    p.closeInventory();
                }
                RegionManager.getInstance().saveRegion(region);
                RegionManager.getInstance().updateSignStatus(region);
                break;
            }
            case "interaktionen": {
                INTERACTION_EDITING.put(p.getUniqueId(), region);
                InteractionSettingsGUI.open(p, region);
                break;
            }
            case "frei:": {
                region.setFree(!region.isFree());
                p.sendMessage(String.valueOf(ChatColor.GREEN) + "Region " + region.getName() + " ist jetzt " + (region.isFree() ? "frei" : "nicht frei") + ".");
                RegionManager.getInstance().saveRegion(region);
                RegionGUI.open(p, region);
                RegionManager.getInstance().updateSignStatus(region);
                break;
            }
            case "aktiv:": {
                region.setActive(!region.isActive());
                p.sendMessage(String.valueOf(ChatColor.GREEN) + "Region " + region.getName() + " ist jetzt " + (region.isActive() ? "aktiv" : "inaktiv") + ".");
                RegionManager.getInstance().saveRegion(region);
                RegionGUI.open(p, region);
                break;
            }
            case "preis festlegen": {
                p.closeInventory();
                RegionManager.getInstance().startPriceChange(p, region);
                break;
            }
            case "kaufen oder mieten": {
                region.setBuyable(!region.isBuyable());
                region.setCoOwner("null");
                p.sendMessage(String.valueOf(ChatColor.GREEN) + "Region " + region.getName() + " ist jetzt " + (region.isBuyable() ? "zum Kaufen" : "zum Vermieten") + ".");
                RegionManager.getInstance().saveRegion(region);
                RegionManager.getInstance().updateSignStatus(region);
                RegionGUI.open(p, region);
                p.closeInventory();
                List<BlockStateData> savedBlocks = RegionManager.getInstance().saveRegionBlocks(region);
                region.setSavedBlocks(savedBlocks);
                break;
            }
            case "besitzer \u00e4ndern": {
                p.sendMessage("\u00a7eDie Besitzer-\u00c4nderung ist noch nicht implementiert.");
                break;
            }
            case "schlie\u00dfen": {
                p.closeInventory();
                break;
            }
            case "zur\u00fcck geben": {
                region.setFree(true);
                RegionManager.getInstance().updateSignStatus(region);
                RegionManager.getInstance().resetRegion(region, p);
                p.sendMessage("\u00a72Du hast die Region erfolgreich zur\u00fcckgegeben!");
                p.closeInventory();
                if (region.isBuyable()) {
                    region.setOwner(null);
                    UserDataManager.addBalance(p.getUniqueId(), region.getPrice() * 0.6);
                    UserDataManager.logTransactionAsReceipt(p.getUniqueId(), "FL Immobilien", region.getPrice() * 0.6, "Region an den Server zur\u00fcck gegeben.");
                    p.sendMessage("\u00a72Du hast 60% vom Grundst\u00fcckspreis erstattet bekommen.");
                    break;
                }
                region.setCoOwner("null");
                break;
            }
            case "schild entfernen": {
                this.removeSign(p, region);
                break;
            }
            default: {
                p.sendMessage("\u00a7cUnbekannte Aktion: " + displayName);
            }
        }
    }

    private void removeSign(Player p, Region region) {
        List<Location> signs = region.getSigns();
        Location playerLocation = p.getLocation();
        Location closestSign = null;
        double closestDistanceSquared = Double.MAX_VALUE;
        for (Location signLocation : signs) {
            double distanceSquared = playerLocation.distanceSquared(signLocation);
            if (!(distanceSquared < closestDistanceSquared)) continue;
            closestDistanceSquared = distanceSquared;
            closestSign = signLocation;
        }
        assert (closestSign != null);
        closestSign.getBlock().setType(Material.AIR);
        region.removeSign(closestSign);
        RegionManager.getInstance().saveRegion(region);
        p.sendMessage("\u00a72Das Schild wurde erfolgreich entfernt.");
    }
}

