/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools.Elevator;

import de.flipper1406.futureleague_wirtschaft.Tools.Elevator.Elevator;
import de.flipper1406.futureleague_wirtschaft.Tools.Elevator.ElevatorManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Switch;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ElevatorCommand
implements CommandExecutor {
    private final ElevatorManager manager;
    private final int maxTargetRange = 5;
    private final Map<Player, Location> pendingChangeMap = new HashMap<Player, Location>();

    public ElevatorCommand(ElevatorManager elevatorManager) {
        this.manager = elevatorManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage("\u00a7cBenutze: /aufzug erstellen <Name> oder /aufzug entfernen");
            return true;
        }
        if (label.equalsIgnoreCase("aufzug")) {
            switch (args[0].toLowerCase()) {
                case "erstellen": {
                    return this.handleCreate(player, args);
                }
                case "entfernen": {
                    return this.handleRemove(player);
                }
                case "changeposition": {
                    return this.handleChangePosition(player, args);
                }
                case "changename": {
                    return this.handleChangeName(player, args);
                }
            }
            return false;
        }
        return false;
    }

    private boolean handleCreate(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage("\u00a7cBitte gib einen Namen an.");
            return true;
        }
        Block target = this.getTargetBlock(player);
        if (target == null) {
            return true;
        }
        if (this.manager.elevatorExists(target.getLocation())) {
            player.sendMessage("\u00a7cAn diesem Knopf existiert bereits ein Aufzug.");
            return true;
        }
        if (this.isInvalidButtonPosition(target)) {
            player.sendMessage("\u00a7cDer Knopf darf nicht an Boden oder Decke sein.");
            return true;
        }
        String name = args[1];
        Elevator elevator = new Elevator(name, player.getName(), target.getLocation(), player.getLocation());
        this.manager.saveElevator(elevator);
        player.sendMessage("\u00a7aAufzug \u00a7e" + name + " \u00a7awurde erstellt.");
        return true;
    }

    private boolean handleRemove(Player player) {
        Block target = this.getTargetBlock(player);
        if (target == null) {
            return true;
        }
        if (!this.manager.elevatorExists(target.getLocation())) {
            player.sendMessage("\u00a7cKein Aufzug an diesem Knopf.");
            return true;
        }
        if (!this.manager.canRemove(player, target.getLocation())) {
            player.sendMessage("\u00a7cDu darfst diesen Aufzug nicht entfernen.");
            return true;
        }
        this.manager.removeElevator(target.getLocation());
        player.sendMessage("\u00a7aAufzug entfernt.");
        return true;
    }

    private boolean handleChangePosition(Player player, String[] args) {
        if (args.length == 1) {
            return this.selectElevatorForPositionChange(player);
        }
        if (args.length == 2 && args[1].equalsIgnoreCase("confirm")) {
            return this.confirmPositionChange(player);
        }
        return false;
    }

    private boolean handleChangeName(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage("\u00a7cBitte gib einen neuen Namen an.");
            return true;
        }
        Block target = this.getTargetBlock(player);
        if (target == null) {
            return true;
        }
        Location buttonLoc = target.getLocation();
        if (!this.manager.elevatorExists(buttonLoc)) {
            player.sendMessage("\u00a7cKein Aufzug an diesem Knopf gefunden.");
            return true;
        }
        List<Elevator> elevators = this.manager.getElevatorsOnXZ(buttonLoc.getBlockX(), buttonLoc.getBlockZ(), buttonLoc.getWorld());
        for (Elevator el : elevators) {
            if (!el.getButtonLocation().equals((Object)buttonLoc)) continue;
            String newName = args[1];
            Elevator updated = new Elevator(newName, el.getOwner(), el.getButtonLocation(), el.getTeleportLocation());
            this.manager.saveElevator(updated);
            player.sendMessage("\u00a7aName des Aufzugs wurde zu \u00a7e" + newName + " \u00a7age\u00e4ndert.");
            return true;
        }
        player.sendMessage("\u00a7cFehler: Aufzug konnte nicht gefunden werden.");
        return true;
    }

    private boolean selectElevatorForPositionChange(Player player) {
        Block target = this.getTargetBlock(player);
        if (target == null) {
            return false;
        }
        if (!this.manager.elevatorExists(target.getLocation())) {
            player.sendMessage("\u00a7cAn diesem Knopf existiert kein Aufzug.");
            return false;
        }
        if (!this.manager.canRemove(player, target.getLocation())) {
            player.sendMessage("\u00a7cDu hast keine Berechtigung, diesen Aufzug zu bearbeiten.");
            return false;
        }
        this.pendingChangeMap.put(player, target.getLocation());
        player.sendMessage("\u00a7aAufzug gefunden. Benutze \u00a7e/aufzug changeposition confirm\u00a7a, um die Position zu aktualisieren.");
        return true;
    }

    private boolean confirmPositionChange(Player player) {
        Location buttonLoc = this.pendingChangeMap.get(player);
        if (buttonLoc == null) {
            player.sendMessage("\u00a7cDu hast keinen Aufzug ausgew\u00e4hlt. Nutze zuerst \u00a7e/aufzug changeposition\u00a7c.");
            return false;
        }
        List<Elevator> elevators = this.manager.getElevatorsOnXZ(buttonLoc.getBlockX(), buttonLoc.getBlockZ(), buttonLoc.getWorld());
        for (Elevator el : elevators) {
            if (!el.getButtonLocation().equals((Object)buttonLoc)) continue;
            Location newTeleportLoc = player.getLocation();
            Elevator updated = new Elevator(el.getName(), el.getOwner(), el.getButtonLocation(), newTeleportLoc);
            this.manager.saveElevator(updated);
            this.pendingChangeMap.remove(player);
            player.sendMessage("\u00a7aDie Teleport-Position f\u00fcr den Aufzug \u00a7e" + el.getName() + " \u00a7awurde gespeichert.");
            return true;
        }
        player.sendMessage("\u00a7cFehler: Aufzug nicht gefunden.");
        return true;
    }

    private Block getTargetBlock(Player player) {
        Block target = player.getTargetBlockExact(5);
        if (target == null || !(target.getBlockData() instanceof Switch)) {
            player.sendMessage("\u00a7cDu musst einen Knopf anvisieren!");
        }
        return target;
    }

    private boolean isInvalidButtonPosition(Block target) {
        BlockFace face = ((Directional)target.getBlockData()).getFacing();
        return face == BlockFace.UP || face == BlockFace.DOWN;
    }
}

