/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Tools;

import de.flipper1406.futureleague_wirtschaft.Tools.LibraryBookManager;
import de.flipper1406.futureleague_wirtschaft.futureLeagueWirtschaft;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LibraryBooks
implements Listener,
CommandExecutor {
    private final futureLeagueWirtschaft plugin;
    private static final double EFFECT_OFFSET_X = 0.5;
    private static final double EFFECT_OFFSET_Y = 1.0;
    private static final double EFFECT_OFFSET_Z = 0.5;
    private static final int MAX_TARGET_DISTANCE = 5;
    private final LibraryBookManager bookManager;
    private static final int ENCHANT_PARTICLE_COUNT = 30;
    private static final double ENCHANT_PARTICLE_OFFSET_X = 0.5;
    private static final double ENCHANT_PARTICLE_OFFSET_Y = 0.5;
    private static final double ENCHANT_PARTICLE_OFFSET_Z = 0.5;
    private static final double ENCHANT_PARTICLE_SPEED = 0.05;
    private static final int PORTAL_PARTICLE_COUNT = 15;
    private static final double PORTAL_PARTICLE_OFFSET_X = 0.3;
    private static final double PORTAL_PARTICLE_OFFSET_Y = 0.7;
    private static final double PORTAL_PARTICLE_OFFSET_Z = 0.3;
    private static final double PORTAL_PARTICLE_SPEED = 0.02;
    private static final float ENCHANT_SOUND_VOLUME = 1.0f;
    private static final float ENCHANT_SOUND_PITCH = 1.2f;
    private static final float BOOKSHELF_HIT_VOLUME = 0.6f;
    private static final float BOOKSHELF_HIT_PITCH = 0.8f;
    private static final String CONFIG_KEY = "LibraryLocations";

    public LibraryBooks(futureLeagueWirtschaft wirtschaftsPlugin, LibraryBookManager libraryBookManager) {
        this.plugin = wirtschaftsPlugin;
        this.bookManager = libraryBookManager;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || block.getType() != Material.BOOKSHELF) {
            return;
        }
        if (!this.isLibraryBlock(block.getLocation())) {
            return;
        }
        Player player = event.getPlayer();
        Location effectLoc = block.getLocation().add(0.5, 1.0, 0.5);
        this.playEffects(effectLoc);
        ItemStack book = this.bookManager.getRandomBook();
        if (book != null) {
            player.openBook(book);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> player.getInventory().remove(book), 1L);
        }
        event.setCancelled(true);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            this.sendUsage(player);
            return true;
        }
        Block target = player.getTargetBlockExact(5);
        if (target == null || target.getType() != Material.BOOKSHELF) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Du musst ein B\u00fccherregal anvisieren!");
            return true;
        }
        Location loc = target.getLocation();
        if (args[0].equalsIgnoreCase("add")) {
            this.addLibraryLocation(loc, player);
            return true;
        }
        if (args[0].equalsIgnoreCase("remove")) {
            this.removeLibraryLocation(loc);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "B\u00fccherregal entfernt!");
            return true;
        }
        this.sendUsage(player);
        return true;
    }

    private boolean isLibraryBlock(Location loc) {
        for (Location saved : this.getLibraryLocations()) {
            if (!saved.equals((Object)loc)) continue;
            return true;
        }
        return false;
    }

    private void addLibraryLocation(Location loc, Player player) {
        List<Location> saved = this.getLibraryLocations();
        if (saved.contains(loc)) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Dieses B\u00fccherregal ist bereits registriert.");
            return;
        }
        saved.add(loc);
        this.saveLibraryLocations(saved);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "B\u00fccherregal hinzugef\u00fcgt!");
    }

    private void removeLibraryLocation(Location loc) {
        List<Location> saved = this.getLibraryLocations();
        saved.removeIf(l -> l.equals((Object)loc));
        this.saveLibraryLocations(saved);
    }

    private List<Location> getLibraryLocations() {
        List raw = this.plugin.getConfig().getList(CONFIG_KEY);
        ArrayList<Location> result = new ArrayList<Location>();
        if (raw != null) {
            for (Object obj : raw) {
                if (!(obj instanceof Location)) continue;
                Location location = (Location)obj;
                result.add(location);
            }
        }
        return result;
    }

    private void saveLibraryLocations(List<Location> locations) {
        this.plugin.getConfig().set(CONFIG_KEY, locations);
        this.plugin.saveConfig();
    }

    private void playEffects(Location loc) {
        loc.getWorld().spawnParticle(Particle.ENCHANT, loc, 30, 0.5, 0.5, 0.5, 0.05);
        loc.getWorld().spawnParticle(Particle.PORTAL, loc, 15, 0.3, 0.7, 0.3, 0.02);
        loc.getWorld().playSound(loc, Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.2f);
        loc.getWorld().playSound(loc, Sound.BLOCK_CHISELED_BOOKSHELF_HIT, 0.6f, 0.8f);
    }

    private void sendUsage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.RED) + "Benutze: /libary add oder /libary remove");
    }
}

