/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import de.flipper1406.futureleague_wirtschaft.Permissions.DatabaseManager;
import de.flipper1406.futureleague_wirtschaft.Permissions.PermissionManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatListener
implements Listener {
    private final PermissionManager permManager;
    private final JavaPlugin plugin;
    private final DatabaseManager databaseManager;
    private final String serverName;

    public ChatListener(JavaPlugin plugin, PermissionManager permManager, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.permManager = permManager;
        this.databaseManager = databaseManager;
        this.serverName = plugin.getConfig().getString("server-name", "unknown");
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String prefix = this.permManager.getPrefix(player.getUniqueId().toString());
        event.setCancelled(true);
        this.broadcastMessage(prefix + " " + player.getName() + " \u00a74>> \u00a72" + event.getMessage());
        String serverName = this.plugin.getConfig().getString("server-name", "unknown");
        this.databaseManager.logChat(player.getUniqueId(), event.getMessage(), serverName);
    }

    public void broadcastMessage(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(message);
        }
    }
}

