/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DatabaseManager {
    private final JavaPlugin plugin;
    private Connection connection;
    private String host;
    private int port;
    private String database;
    private String username;
    private String password;

    public DatabaseManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfigData();
    }

    private void loadConfigData() {
        this.host = this.plugin.getConfig().getString("database.host", "localhost");
        this.port = this.plugin.getConfig().getInt("database.port", 3306);
        this.database = this.plugin.getConfig().getString("database.db", "minecraft");
        this.username = this.plugin.getConfig().getString("database.user", "root");
        this.password = this.plugin.getConfig().getString("database.password", "");
    }

    public void connect() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return;
        }
        String url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=false&serverTimezone=UTC";
        this.connection = DriverManager.getConnection(url, this.username, this.password);
        this.plugin.getLogger().info("\u2705 MySQL-Datenbank verbunden: " + this.host + ":" + this.port + "/" + this.database);
        this.startKeepAlive();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void disconnect() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.plugin.getLogger().info("\u274c MySQL-Datenbank getrennt.");
        }
    }

    private void startKeepAlive() {
        new BukkitRunnable(){

            public void run() {
                try {
                    DatabaseManager.this.reconnectIfNeeded();
                    if (DatabaseManager.this.isConnectionValid()) {
                        Statement statement = DatabaseManager.this.connection.createStatement();
                        statement.executeQuery("SELECT 1");
                        statement.close();
                        DatabaseManager.this.plugin.getLogger().info("Datenbank KeepAlive gesendet.");
                    }
                }
                catch (Exception e) {
                    DatabaseManager.this.plugin.getLogger().warning("KeepAlive fehlgeschlagen \u2013 versuche reconnect...");
                    try {
                        DatabaseManager.this.reconnectIfNeeded();
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 1200L, 2400L);
    }

    public void reconnectIfNeeded() throws SQLException {
        if (!this.isConnectionValid()) {
            this.plugin.getLogger().info("Verbindung ist nicht mehr g\u00fcltig. Stelle neue Verbindung her...");
            this.disconnect();
            this.connect();
        }
    }

    public boolean isConnectionValid() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void logChat(UUID playerUUID, String message, String server) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerUUID);
        String username = player.getName();
        if (username == null) {
            username = "UNKNOWN";
        }
        String sql = "INSERT INTO chatLog (username, userUUID, message, server)\nVALUES (?, ?, ?, ?)\n";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, username);
            stmt.setString(2, playerUUID.toString());
            stmt.setString(3, message);
            stmt.setString(4, server);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

