/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Permissions;

import de.flipper1406.futureleague_wirtschaft.Permissions.PermissionCache;
import de.flipper1406.futureleague_wirtschaft.Permissions.PermissionWildcardResolver;
import de.flipper1406.futureleague_wirtschaft.futureLeagueWirtschaft;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class PermissionListener
implements Listener {
    private final PermissionCache cache;
    private final Map<UUID, PermissionAttachment> attachments = new HashMap<UUID, PermissionAttachment>();

    public PermissionListener(PermissionCache cache) {
        this.cache = cache;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String server = futureLeagueWirtschaft.getInstance().getConfig().getString("server-name", "unknown");
        this.cache.load(uuid, server);
        PermissionAttachment attachment = player.addAttachment((Plugin)futureLeagueWirtschaft.getInstance());
        this.attachments.put(uuid, attachment);
        for (String perm : this.cache.getPermissions(uuid, server)) {
            if (perm.equals("*") || perm.endsWith(".*")) {
                for (String resolved : PermissionWildcardResolver.resolve(perm)) {
                    attachment.setPermission(resolved, true);
                }
                continue;
            }
            attachment.setPermission(perm, true);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        PermissionAttachment attachment = this.attachments.remove(uuid);
        if (attachment != null) {
            attachment.remove();
        }
        this.cache.clear(uuid);
    }
}

