/*
 * Decompiled with CFR 0.152.
 */
package de.flipper1406.futureleague_wirtschaft.Regions;

import de.flipper1406.futureleague_wirtschaft.Regions.RegionManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class BlockStateData {
    private final int x;
    private final int y;
    private final int z;
    private final Material material;
    private final BlockData blockData;

    public BlockStateData(int locationX, int locationY, int locationZ, Material locationMaterial, BlockData locationBlockData) {
        this.x = locationX;
        this.y = locationY;
        this.z = locationZ;
        this.material = locationMaterial;
        this.blockData = locationBlockData;
    }

    public BlockStateData(Block block) {
        this.x = block.getX();
        this.y = block.getY();
        this.z = block.getZ();
        this.material = block.getType();
        this.blockData = block.getBlockData().clone();
    }

    public void restoreBlock(World world) {
        Block block = world.getBlockAt(this.x, this.y, this.z);
        Location blockLocation = new Location(world, (double)this.x, (double)this.y, (double)this.z);
        if (RegionManager.getInstance().getRegion(blockLocation) != null) {
            block.setType(this.material, false);
            block.setBlockData(this.blockData, false);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Material getMaterial() {
        return this.material;
    }

    public BlockData getBlockData() {
        return this.blockData;
    }
}

